Name: intel-igb
Summary: Intel(R) Gigabit Ethernet Linux Driver
Version: 5.13.16
Release: 1
Source: %{name}-%{version}.tar.bz2
License: GPL
Vendor: Intel Corporation
Group: System/Kernel
URL: http://support.intel.com
BuildRequires: kernel-source kernel-syms pciutils-ids module-init-tools
Requires: pciutils
BuildRoot: %{_tmppath}/%{name}-%{version}-root
%kernel_module_package -x debug -x trace

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL}
%else
%define kernel_ver %(uname -r)
%endif

%description
This package contains the Intel(R) Gigabit Ethernet Linux Driver.

%package KMP
Summary: Igb Kernel Module
Group: System/Kernel

%description KMP
This is one of the sub-packages for a specific kernel.  All the
sub-packages will share the same summary, group, and description.

%prep
%setup
set -- *
mv src source
echo "igb.ko external" > source/Module.supported
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION="%version"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    make -C $PWD/obj/$flavor
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
    make -C %{kernel_source $flavor} modules_install M=$PWD/obj/$flavor
done
mkdir -p $RPM_BUILD_ROOT/usr/share/pci.ids.d
install -D -m 644 pci.updates $RPM_BUILD_ROOT/usr/share/pci.ids.d/pci.ids.intel-igb-%{version}
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man7
install -m 644 -D igb.7 $RPM_BUILD_ROOT/%{_mandir}/man7
gzip -9nf $RPM_BUILD_ROOT/%{_mandir}/man7/*.?

# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
cd %{buildroot}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile %{_usrsrc}/kernels/%{kernel_ver}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=%{_usrsrc}/kernels/%{kernel_ver} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_mandir}/man7/igb.7.gz
/usr/share/pci.ids.d/pci.ids.intel-igb-%{version}
%doc COPYING
%doc README

%post
if [ -x /usr/bin/merge-pciids -a -x /usr/bin/perl ]; then
    /usr/bin/merge-pciids
else
    echo "ERROR: merge-pciids or perl not found"
fi

%postun
if [ -x /usr/bin/merge-pciids -a -x /usr/bin/perl ]; then
    /usr/bin/merge-pciids
else
    echo "ERROR: merge-pciids or perl not found"
fi

%changelog
* Tue Oct 8 2013 - jeffrey.t.kirsher@intel.com
- Updated to reflect CODE 11 changes nd LF standard spec file work.
