Name: irdma
Summary: Intel(R) Ethernet Connection E800 Series Linux iRDMA Driver
%if 0%{?_IRDMA_VER_:1}
%define version %{_IRDMA_VER_}
%else
%define version 0.0.0
%endif
Version: %{version}
Release: 1
Source: %{name}-%{version}.tgz
Vendor: Intel Corporation
License: GPLv2 and Redistributable, no modification permitted
ExclusiveOS: linux
Group: System Environment/Kernel
Provides: %{name}
URL: http://support.intel.com
BuildRoot: %{_tmppath}/%{name}-%{version}-root
%global debug_package %{nil}
%global __strip /bin/true

%define find() %(for f in %*; do if [ -e $f ]; then echo $f; break; fi; done)
Requires: kernel, findutils, gawk, bash

# Check for existence of kernel_module_package_buildreqs ...
%if 0%{?!kernel_module_package_buildreqs:1}
# ... and provide a suitable definition if it is not defined
%define kernel_module_package_buildreqs kernel-devel
%endif

BuildRequires: %kernel_module_package_buildreqs

%description
This package contains the Intel(R) Ethernet Connection E800 Series Linux iRDMA Driver.

%prep
%setup

%build
./build.sh noinstall

# Signing
echo "Start signing"
# Find the sign file script
signtool=`find %{_topdir} -type f -name sign-file`
for module in `find . -type f -name \*.ko`; do
	strip --strip-debug ${module}
	if [ -f ${signtool} ]; then
		source ${signtool} ${module}
	fi
done
if [ -f ${signtool} ]; then
	rm -rf ${signtool}
fi

%install
mkdir -p %{buildroot}/lib/modules/`uname -r`/updates/drivers/infiniband/hw/irdma/
find ./ -iname "irdma.ko" -exec install -D -m 644 {} "%{buildroot}/lib/modules/`uname -r`/updates/drivers/infiniband/hw/irdma/" \;
cd %{buildroot}
find lib -name "irdma.ko" \
	-fprintf %{_builddir}/%{name}-%{version}/file.list "/%p\n"

%clean
rm -rf %{buildroot}

%files -f file.list

%defattr(-,root,root)
%doc file.list

%post

rmmod i40iw 2> /dev/null
rm -f /lib/modules/`uname -r`/kernel/drivers/infiniband/hw/i40iw/i40iw.ko 2> /dev/null
rm -f /lib/modules/`uname -r`/updates/drivers/infiniband/hw/i40iw/i40iw.ko 2> /dev/null
rm -f /lib/modules/`uname -r`/kernel/drivers/infiniband/hw/i40iw/i40iw.ko.xz 2> /dev/null
rm -f /lib/modules/`uname -r`/updates/drivers/infiniband/hw/i40iw/i40iw.ko.xz 2> /dev/null
echo "Creating /etc/modprobe.d/irdma.conf file ..."
mkdir -p "/etc/modprobe.d/"
if [ -e "/etc/modprobe.d/irdma.conf" ]; then
	if [ "" = "$(grep 'blacklist i40iw' /etc/modprobe.d/irdma.conf)" ]; then
		echo "blacklist i40iw"  >>  "/etc/modprobe.d/irdma.conf"
		echo "alias i40iw irdma" >> "/etc/modprobe.d/irdma.conf"
	fi
else
	echo "blacklist i40iw"  >  "/etc/modprobe.d/irdma.conf"
	echo "alias i40iw irdma" >> "/etc/modprobe.d/irdma.conf"
fi

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%preun

%postun
uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

