Name:		iavf
Version:	4.8.2
Release:	1
Summary:	Intel(R) Ethernet Adaptive Virtual Function Driver
Group:		System/Kernel
License:	GPL-2.0
Vendor:		Intel Corporation
URL:		http://support.intel.com
Source0:	kmod-%{name}-%{version}.tar.gz
Source1:	%{name}.files
Source2:	%{name}.conf
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildRequires:	%kernel_module_package_buildreqs
Provides:	%{name}

%define debug_package %{nil}
%global __strip /bin/true

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL} 
%else
%define kernel_ver %(uname -r)
%endif

%if 0%{?KSRC:1}
%define check_aux_args_ksrc -k %{KSRC}
%endif

%define check_aux_args %check_aux_args_kernel %check_aux_args_ksrc

%define need_aux_rpm %( [ -L /lib/modules/%kernel_ver/source ] && (rpm -q --whatprovides /lib/modules/%kernel_ver/source/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) || (rpm -q --whatprovides /lib/modules/%kernel_ver/build/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) )
%if (%need_aux_rpm == 2)
Requires: intel_auxiliary
%endif

# Build only for standard kernel variant(s)
%kernel_module_package -f %{SOURCE1} default

%description
This package contains the Intel(R) Ethernet Adaptive Virtual Function Driver.

%prep
%setup
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
for flavor in %flavors_to_build; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	make -C $PWD/obj/$flavor/src KSRC=%{kernel_source $flavor}
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=extra/%{name}
for flavor in %flavors_to_build; do
	make -C $PWD/obj/$flavor/src KSRC=%{kernel_source $flavor} modules_install mandocs_install

	# Cleanup unnecessary kernel-generated module dependency files.
	find $INSTALL_MOD_PATH/lib/modules -iname 'modules.*' -exec rm {} \;
done
install -m 644 -D %{SOURCE2} $RPM_BUILD_ROOT/etc/depmod.d/%{name}.conf

cd %{buildroot}
find . \( -name "intel_auxiliary.ko" -or -name auxiliary_bus.h \) \
	-fprintf %{_builddir}/%{name}-%{version}/aux.list "/%p\n"


export _ksrc=%{kernel_source $flavor}
cd %{buildroot}
# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile ${_ksrc}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=${_ksrc} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif

%files
/etc/modprobe.d/iavf.conf

%defattr(644,root,root,755)
/etc/depmod.d/iavf.conf
%{_mandir}/man7/iavf.7.gz
%doc source/COPYING
%doc source/README
%doc source/pci.updates

%post
uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

wm2=/usr/lib/module-init-tools/weak-modules2
if [ -x $wm2 ]; then
    kmp=%{name}-%{version}-%{release}.%{_arch}
    /bin/bash -${-/e/} $wm2 --add-kmp $kmp
fi

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%postun
uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

wm2=/usr/lib/module-init-tools/weak-modules2
if [ -x $wm2 ]; then
    modules=( $(cat /var/run/rpm-%{name}-modules.list) )
    kmp=%{name}-%{version}-%{release}.%{_arch}
    printf '%s\n' "${modules[@]}" | /bin/bash -${-/e/} $wm2 --remove-kmp $kmp
fi
rm /var/run/rpm-%{name}-modules.list

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%package -n intel_auxiliary
Summary: Auxiliary bus driver (backport)
Version: 1.0.1

%description -n intel_auxiliary
The Auxiliary bus driver (intel_auxiliary.ko), backported from upstream, for use by kernels that don't have auxiliary bus.

# %if to hide this whole section, causes RPM to not build the subproject at all
%if (%need_aux_rpm == 2)
%files -n intel_auxiliary -f aux.list
%doc aux.list
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%changelog

