@echo off
REM :: Intel(R) Innovation Platform Framework Installer Script
REM :: (c) Copyright 2022 Intel Corporation All Rights Reserved
REM ::
REM :: This script may be used to automatically install or uninstall all the drivers for the
REM :: Intel(R) Innovation Platform Framework (IPF), including the IPF Core API and the
REM :: IPF Extensible Framework. Driver INFs may also be installed manually if desired.
REM ::
REM :: NOTE: This script must be run by an Administrator with "Run as Administrator"
REM ::       Privileges, either from Windows Explorer or from a CMD.EXE Prompt.
REM ::
REM :: Usage: setup.cmd [silent] [ install / uninstall / help ]
REM ::
setlocal enabledelayedexpansion
pushd %~dp0
set DRIVERLIST=ipf_ef_sw.inf ipf_ef_ext.inf ipf_acpi.inf ipf_cpu.inf ipf_lf.inf
set FAILURES=0
set PAUSE=1

call :main %*
goto exit

:main
	REM :: "silent" as first option does not pause on error or parameter-less install
	if /i "%1"=="silent" (
		SET PAUSE=0
		shift
	)

	REM :: Execute parameter-less install or specified option
	if "%1"=="" (
		call :install
		if !FAILURES! NEQ 0 (call :error) else (call :pause)
	) else (
		for %%o in (install uninstall help --help -help -h silent) do if /i "%1"=="%%o" (
			call :%%o
			if !FAILURES! NEQ 0 (call :error)
			exit /b
		)
	)
exit /b

:install
	echo ***
	echo *** Install Intel(R) Innovation Platform Framework Drivers
	echo ***
	for /d %%f in (ipf-core-* ipf-ef-*) do (
		pushd %%f
		pushd drivers\x64
		for %%p in (*.inf) do (
			echo.
			echo *** Installing %%p ...
			pnputil /add-driver %%p /install
			if !ERRORLEVEL! NEQ 0 if !ERRORLEVEL! NEQ 259 set /A FAILURES=!FAILURES!+1
			set LOADEDINF=0
			for /f "delims= tokens=1-3" %%i in ('pnputil /enum-devices /drivers') do (
				set PNPITEM=%%i
				if "!PNPITEM:~4,14!"=="Original Name:" (
					set ORIGINAL=!PNPITEM:~28,255!
					if "!ORIGINAL!"=="%%p" (
						set LOADEDINF=1
					)
				)				
			)
			if !FAILURES! EQU 0 if !LOADEDINF! NEQ 1 (
				echo +++
				echo +++ ERROR Installing %%p: UNSUPPORTED PLATFORM
				echo +++
				echo.
				set /A FAILURES=!FAILURES!+1
				call :uninstall %%p
				popd
				popd
				exit /b
			)
		)
		popd
		popd
	)
	echo ***
	echo *** Install Complete
	echo ***
exit /b

:uninstall
	if not "%1"=="" set DRIVERLIST=%*
	if "%1"=="" (
		echo ***
		echo *** Uninstall Intel^(R^) Innovation Platform Framework Drivers
		echo ***
		echo.
	)
	for %%i in (%DRIVERLIST%) do (
		for /f "delims= tokens=1-3" %%p in ('pnputil /enum-drivers') do (
			set PNPITEM=%%p
			if "!PNPITEM:~0,15!"=="Published Name:" (
				set OEMINF=!PNPITEM:~20,255!
			)
			if "!PNPITEM:~0,14!"=="Original Name:" (
				set ORIGINAL=!PNPITEM:~20,255!
				if "!ORIGINAL!"=="%%i" (
					echo.
					echo *** Uninstalling %%i [!OEMINF!] ...
					pnputil /delete-driver !OEMINF! /uninstall
					if ERRORLEVEL 1 set /A FAILURES=!FAILURES!+1
					echo.
				)
			)
		)
	)
	if "%1"=="" (
		echo ***
		echo *** Uninstall Complete
		echo ***
	)
exit /b

:error
	echo.
	echo +++
	echo +++ ERROR: %FAILURES% Failures Installing/Uninstalling Drivers.
	echo +++ This Script must started with the "Run as Administrator" option from
	echo +++ Windows Explorer or a CMD Prompt in order to Install/Uninstall Drivers.
	echo +++ Drivers will only Install and Load on Supported Platforms.
	echo +++
	call :pause
exit /b

:pause
	if "%PAUSE%"=="1" pause
exit /b

:help
:--help
:-help
:-h
	echo Intel(R) Innovation Platform Framework Driver Setup Script
	echo (c) Copyright 2022 Intel Corporation All Rights Reserved
	echo.
	echo Usage: setup [silent] [option]
	echo Options:
	echo    silent    = Do a Silent Install/Uninstall (no pause)
	echo    install   = Install IPF Drivers [default]
	echo    uninstall = Uninstall IPF Drivers
	echo    help      = Display this Help screen
	echo.
	echo NOTE: This Script must be run by an Administrator with the
	echo "Run as Administrator" option, in Explorer or CMD.EXE.
exit /b

:exit
popd
endlocal