# we do not need debug package
%define debug_package %{nil}
%global __os_install_post %{nil}

Name:		igb
Version:	5.13.16
Release:	1
Summary:	Intel(R) Gigabit Ethernet Linux Driver
Group:		System/Kernel
License:	GPL
Vendor:		Intel Corporation
URL:		http://support.intel.com
Source0:	kmod-%{name}-%{version}.tar.gz
Source1:	%{name}.files
Source2:	%{name}.conf
BuildRoot:	%{_tmppath}/%{name}-%{version}-build
BuildRequires:	%kernel_module_package_buildreqs
Provides:	%{name}

# build only for standard kernel variant(s)
%kernel_module_package -f %{SOURCE1} default

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL}
%else
%define kernel_ver %(uname -r)
%endif

%description
This package contains the Intel(R) Gigabit Ethernet Linux Driver.

%prep
%setup
set -- *
mv src source
mkdir obj

%build
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    make -C $PWD/obj/$flavor

    # mark modules executable so that strip-to-file can strip them
    find obj/$flavor/ -name "*.ko" -type f -exec chmod u+x '{}' +
done
gzip < %{name}.7 > %{SOURCE3}

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=extra/%{name}
for flavor in %flavors_to_build; do
    make -C %{kernel_source $flavor} modules_install M=$PWD/obj/$flavor

    # Cleanup unnecessary kernel-generated module dependency files.
    find $INSTALL_MOD_PATH/lib/modules -iname 'modules.*' -exec rm {} \;
done

install -D -m 644 %{SOURCE2} $RPM_BUILD_ROOT/etc/depmod.d/%{name}.conf
install -D -m 644 %{SOURCE3} $RPM_BUILD_ROOT/usr/share/man/man7/%{name}.7.gz

# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
cd %{buildroot}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile %{_usrsrc}/kernels/%{kernel_ver}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=%{_usrsrc}/kernels/%{kernel_ver} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Fri Dec 12 2014 - jeffrey.t.kirsher@intel.com
- Updated to reflect RHEL 7.0 changes needed.
