Name: intel-ixgbevf
Summary: Intel(R) 10GbE PCI Express Virtual Function Driver
Version: 4.17.11
Release: 1
Source0: %{name}-%{version}.tar.bz2
License: GPL-2.0
Vendor: Intel Corporation
Group: System/Kernel
URL: http://support.intel.com
BuildRequires: %kernel_module_package_buildreqs pciutils-ids dracut
Requires: pciutils-ids
BuildRoot: %{_tmppath}/%{name}-%{version}-build

%global __strip /bin/true

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL} 
%else
%define kernel_ver %(uname -r)
%endif

%if 0%{?KSRC:1}
%define check_aux_args_ksrc -k %{KSRC}
%endif

%define check_aux_args %check_aux_args_kernel %check_aux_args_ksrc

%description
This package contains the Intel(R) 10GbE PCI Express Virtual Function Driver.

%kernel_module_package
%package KMP
Summary: Intel(R) 10GbE PCI Express Virtual Function Driver kernel module
Group: System/Kernel
%description KMP
This package contains the Intel(R) 10GbE PCI Express Virtual Function Driver.

%debug_package

%prep n %{name}-%{version}
%setup -q
set -- *
mkdir source
mv "$@" source/.
echo "ixgbevf.ko external" > source/Module.supported
mkdir obj

%build
# flavors_to_build and kernel_source defined by kernel_module_package
for flavor in %flavors_to_build; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	make -C $PWD/obj/$flavor/src KSRC=%{kernel_source $flavor}
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
	make -C $PWD/obj/$flavor/src KSRC=%{kernel_source $flavor} \
		MANDIR=%{_mandir} modules_install mandocs_install
done
mkdir -p $RPM_BUILD_ROOT/usr/share/pci.ids.d
install -D -m 0644 source/pci.updates \
	$RPM_BUILD_ROOT/usr/share/pci.ids.d/pci.ids.%{name}-%{version}


export _ksrc=%{kernel_source $flavor}
cd %{buildroot}
# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile ${_ksrc}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=${_ksrc} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif

%clean
rm -rf %{buildroot}

%files

%defattr(-,root,root)
%{_mandir}/man7/ixgbevf.7.gz
/usr/share/pci.ids.d/pci.ids.%{name}-%{version}
%doc source/COPYING
%doc source/README

%post
/usr/bin/merge-pciids

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

wm2=/usr/lib/module-init-tools/weak-modules2
if [ -x $wm2 ]; then
    kmp=%{name}-%{version}-%{release}.%{_arch}
    /bin/bash -${-/e/} $wm2 --add-kmp $kmp
fi

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%preun
# save tmp list of installed kernel modules for weak-modules2
kmp=%{name}-%{version}-%{release}.%{_arch}
rpm -ql $kmp | sed -n '/\.ko\(\.xz\)?$/p' > /var/run/rpm-%{name}-modules.list

%postun
/usr/bin/merge-pciids

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

wm2=/usr/lib/module-init-tools/weak-modules2
if [ -x $wm2 ]; then
    modules=( $(cat /var/run/rpm-%{name}-modules.list) )
    kmp=%{name}-%{version}-%{release}.%{_arch}
    printf '%s\n' "${modules[@]}" | /bin/bash -${-/e/} $wm2 --remove-kmp $kmp
fi
rm /var/run/rpm-%{name}-modules.list

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%changelog

