Name: intel-i40e
Summary: Intel(R) 40-10 Gigabit Ethernet Connection Network Driver
Version: 2.22.18
Release: 1
Source0: %{name}-%{version}.tar.bz2
License: GPL-2.0
Vendor: Intel Corporation
Group: System/Kernel
URL: http://support.intel.com
BuildRequires: %kernel_module_package_buildreqs pciutils-ids dracut
Requires: pciutils-ids
BuildRoot: %{_tmppath}/%{name}-%{version}-build

%global __strip /bin/true

%if 0%{?BUILD_KERNEL:1}
%define kernel_ver %{BUILD_KERNEL}
%define check_aux_args_kernel -b %{BUILD_KERNEL} 
%else
%define kernel_ver %(uname -r)
%endif

%if 0%{?KSRC:1}
%define check_aux_args_ksrc -k %{KSRC}
%endif

%define check_aux_args %check_aux_args_kernel %check_aux_args_ksrc

%define need_aux_rpm %( [ -L /lib/modules/%kernel_ver/source ] && (rpm -q --whatprovides /lib/modules/%kernel_ver/source/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) || (rpm -q --whatprovides /lib/modules/%kernel_ver/build/include/linux/auxiliary_bus.h > /dev/null 2>&1 && echo 0 || echo 2) )
%if (%need_aux_rpm == 2)
Requires: intel_auxiliary
%endif

%description
This package contains the Intel(R) 40-10 Gigabit Ethernet Connection Network Driver.

%kernel_module_package
%package KMP
Summary: Intel(R) 40-10 Gigabit Ethernet Connection Network Driver kernel module
Group: System/Kernel
%description KMP
This package contains the Intel(R) 40-10 Gigabit Ethernet Connection Network Driver.

%debug_package

%prep n %{name}-%{version}
%setup -q
set -- *
mkdir source
mv "$@" source/.
echo "i40e.ko external" > source/Module.supported
mkdir obj

%if (%need_aux_rpm == 2)
echo "intel_auxiliary.ko external" >> source/Module.supported
%endif

%build
# flavors_to_build and kernel_source defined by kernel_module_package
for flavor in %flavors_to_build; do
	rm -rf obj/$flavor
	cp -r source obj/$flavor
	make -C $PWD/obj/$flavor/src
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
	make -C $PWD/obj/$flavor/src \
		MANDIR=%{_mandir} modules_install mandocs_install
done
mkdir -p $RPM_BUILD_ROOT/usr/share/pci.ids.d
install -D -m 0644 source/pci.updates \
	$RPM_BUILD_ROOT/usr/share/pci.ids.d/pci.ids.%{name}-%{version}

cd %{buildroot}
find . \( -name "intel_auxiliary.ko" -or -name auxiliary_bus.h \) \
	-fprintf %{_builddir}/%{name}-%{version}/aux.list "/%p\n"


export _ksrc=%{kernel_source $flavor}
cd %{buildroot}
# Sign the modules(s)
%if %{?_with_modsign:1}%{!?_with_modsign:0}
%define __strip /bin/true
%{!?privkey: %define privkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.priv}
%{!?pubkey: %define pubkey %{_sysconfdir}/pki/SECURE-BOOT-KEY.der}
%{!?_signfile: %define _signfile ${_ksrc}/scripts/sign-file}
for module in `find . -type f -name *.ko`;
do
strip --strip-debug ${module}
$(KSRC=${_ksrc} %{_signfile} sha512 %{privkey} %{pubkey} ${module} > /dev/null 2>&1)
done
%endif

%clean
rm -rf %{buildroot}

%files

%defattr(-,root,root)
%{_mandir}/man7/i40e.7.gz
/usr/share/pci.ids.d/pci.ids.%{name}-%{version}
%doc source/COPYING
%doc source/README

%post
/usr/bin/merge-pciids

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

wm2=/usr/lib/module-init-tools/weak-modules2
if [ -x $wm2 ]; then
    kmp=%{name}-%{version}-%{release}.%{_arch}
    /bin/bash -${-/e/} $wm2 --add-kmp $kmp
fi

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%preun
# save tmp list of installed kernel modules for weak-modules2
kmp=%{name}-%{version}-%{release}.%{_arch}
rpm -ql $kmp | sed -n '/\.ko\(\.xz\)?$/p' > /var/run/rpm-%{name}-modules.list

%postun
/usr/bin/merge-pciids

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

wm2=/usr/lib/module-init-tools/weak-modules2
if [ -x $wm2 ]; then
    modules=( $(cat /var/run/rpm-%{name}-modules.list) )
    kmp=%{name}-%{version}-%{release}.%{_arch}
    printf '%s\n' "${modules[@]}" | /bin/bash -${-/e/} $wm2 --remove-kmp $kmp
fi
rm /var/run/rpm-%{name}-modules.list

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

%package -n intel_auxiliary
Summary: Auxiliary bus driver (backport)
Version: 1.0.1

%description -n intel_auxiliary
The Auxiliary bus driver (intel_auxiliary.ko), backported from upstream, for use by kernels that don't have auxiliary bus.

# %if to hide this whole section, causes RPM to not build the subproject at all
%if (%need_aux_rpm == 2)
%files -n intel_auxiliary -f aux.list
%doc aux.list
%endif

%changelog

