/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2015 - 2019 Intel Corporation */
#ifndef IRDMA_DEFS_H
#define IRDMA_DEFS_H

#define IRDMA_FIRST_USER_QP_ID	3

#define ECN_CODE_PT_VAL	2

#define IRDMA_PUSH_OFFSET		(8 * 1024 * 1024)
#define IRDMA_PF_FIRST_PUSH_PAGE_INDEX	16
#define IRDMA_PF_BAR_RSVD		(60 * 1024)
#define IRDMA_VF_PUSH_OFFSET		((8 + 64) * 1024)
#define IRDMA_VF_FIRST_PUSH_PAGE_INDEX	2
#define IRDMA_VF_BAR_RSVD		4096
#define IRDMA_VF_STATS_SIZE_V0	280

#define IRDMA_PE_DB_SIZE_4M	1
#define IRDMA_PE_DB_SIZE_8M	2

enum irdma_protocol_used {
	IRDMA_ANY_PROTOCOL = 0,
	IRDMA_IWARP_PROTOCOL_ONLY = 1,
	IRDMA_ROCE_PROTOCOL_ONLY = 2,
};

#define IRDMA_QP_STATE_INVALID		0
#define IRDMA_QP_STATE_IDLE		1
#define IRDMA_QP_STATE_RTS		2
#define IRDMA_QP_STATE_CLOSING		3
#define IRDMA_QP_STATE_RTR		4
#define IRDMA_QP_STATE_TERMINATE	5
#define IRDMA_QP_STATE_ERROR		6

#define IRDMA_MAX_TRAFFIC_CLASS		8
#define IRDMA_MAX_USER_PRIORITY		8
#define IRDMA_MAX_APPS			8
#define IRDMA_MAX_STATS_COUNT		128
#define IRDMA_FIRST_NON_PF_STAT		4

#define IRDMA_MIN_MTU_IPV4	576
#define IRDMA_MIN_MTU_IPV6	1280
#define IRDMA_MTU_TO_MSS_IPV4	40
#define IRDMA_MTU_TO_MSS_IPV6	60
#define IRDMA_DEFAULT_MTU	1500

#define IRDMA_MAX_ENCODED_IRD_SIZE	4

#define Q2_FPSN_OFFSET		64
#define TERM_DDP_LEN_TAGGED	14
#define TERM_DDP_LEN_UNTAGGED	18
#define TERM_RDMA_LEN		28
#define RDMA_OPCODE_M		0x0f
#define RDMA_READ_REQ_OPCODE	1
#define Q2_BAD_FRAME_OFFSET	72
#define CQE_MAJOR_DRV		0x8000

#define IRDMA_TERM_SENT		1
#define IRDMA_TERM_RCVD		2
#define IRDMA_TERM_DONE		4
#define IRDMA_MAC_HLEN		14

#define IRDMA_CQP_WAIT_POLL_REGS	1
#define IRDMA_CQP_WAIT_POLL_CQ		2
#define IRDMA_CQP_WAIT_EVENT		3

#define IRDMA_AE_SOURCE_RSVD		0x0
#define IRDMA_AE_SOURCE_RQ		0x1
#define IRDMA_AE_SOURCE_RQ_0011		0x3

#define IRDMA_AE_SOURCE_CQ		0x2
#define IRDMA_AE_SOURCE_CQ_0110		0x6
#define IRDMA_AE_SOURCE_CQ_1010		0xa
#define IRDMA_AE_SOURCE_CQ_1110		0xe

#define IRDMA_AE_SOURCE_SQ		0x5
#define IRDMA_AE_SOURCE_SQ_0111		0x7

#define IRDMA_AE_SOURCE_IN_RR_WR	0x9
#define IRDMA_AE_SOURCE_IN_RR_WR_1011	0xb
#define IRDMA_AE_SOURCE_OUT_RR		0xd
#define IRDMA_AE_SOURCE_OUT_RR_1111	0xf

#define IRDMA_TCP_STATE_NON_EXISTENT	0
#define IRDMA_TCP_STATE_CLOSED		1
#define IRDMA_TCP_STATE_LISTEN		2
#define IRDMA_STATE_SYN_SEND		3
#define IRDMA_TCP_STATE_SYN_RECEIVED	4
#define IRDMA_TCP_STATE_ESTABLISHED	5
#define IRDMA_TCP_STATE_CLOSE_WAIT	6
#define IRDMA_TCP_STATE_FIN_WAIT_1	7
#define IRDMA_TCP_STATE_CLOSING		8
#define IRDMA_TCP_STATE_LAST_ACK	9
#define IRDMA_TCP_STATE_FIN_WAIT_2	10
#define IRDMA_TCP_STATE_TIME_WAIT	11
#define IRDMA_TCP_STATE_RESERVED_1	12
#define IRDMA_TCP_STATE_RESERVED_2	13
#define IRDMA_TCP_STATE_RESERVED_3	14
#define IRDMA_TCP_STATE_RESERVED_4	15

#define IRDMA_CQP_SW_SQSIZE_4		4
#define IRDMA_CQP_SW_SQSIZE_2048	2048

#define IRDMA_CQ_TYPE_IWARP	1
#define IRDMA_CQ_TYPE_ILQ	2
#define IRDMA_CQ_TYPE_IEQ	3
#define IRDMA_CQ_TYPE_CQP	4
/* CQP SQ WQES */
#define IRDMA_QP_TYPE_IWARP	1
#define IRDMA_QP_TYPE_UDA	2
#define IRDMA_QP_TYPE_ROCE_RC	3
#define IRDMA_QP_TYPE_ROCE_UD	4

#define IRDMA_DONE_COUNT	1000
#define IRDMA_SLEEP_COUNT	10

#define IRDMA_UPDATE_SD_BUFF_SIZE	128
#define IRDMA_FEATURE_BUF_SIZE		(8 * IRDMA_MAX_FEATURES)

#define IRDMA_MAX_QUANTA_PER_WR	8

#define IRDMA_QP_SW_MAX_WQ_QUANTA	32768
#define IRDMA_QP_SW_MAX_SQ_QUANTA	32768
#define IRDMA_QP_SW_MAX_RQ_QUANTA	32768
#define IRDMA_MAX_QP_WRS(max_quanta_per_wr) \
	((IRDMA_QP_SW_MAX_WQ_QUANTA - IRDMA_SQ_RSVD) / (max_quanta_per_wr))

#define IRDMAQP_TERM_SEND_TERM_AND_FIN		0
#define IRDMAQP_TERM_SEND_TERM_ONLY		1
#define IRDMAQP_TERM_SEND_FIN_ONLY		2
#define IRDMAQP_TERM_DONOT_SEND_TERM_OR_FIN	3

#define IRDMA_HW_PAGE_SIZE	4096
#define IRDMA_HW_PAGE_SHIFT	12
#define IRDMA_CQE_QTYPE_RQ	0
#define IRDMA_CQE_QTYPE_SQ	1

#define IRDMA_QP_SW_MIN_WQSIZE	8u /* in WRs*/
#define IRDMA_QP_WQE_MIN_SIZE	32
#define IRDMA_QP_WQE_MAX_SIZE	256
#define IRDMA_QP_WQE_MIN_QUANTA 1
#define IRDMA_MAX_RQ_WQE_SHIFT_GEN1 2
#define IRDMA_MAX_RQ_WQE_SHIFT_GEN2 3

#define IRDMA_SQ_RSVD	258
#define IRDMA_RQ_RSVD	1

#define IRDMA_FEATURE_RTS_AE			1ULL
#define IRDMA_FEATURE_CQ_RESIZE			2ULL
#define IRDMA_FEATURE_RELAX_RQ_ORDER		4ULL
#define IRDMA_FEATURE_ENFORCE_SQ_SIZE		8ULL
#define IRDMA_FEATURE_FORCE_FENCE		16ULL
#define IRDMA_FEATURE_ATOMIC_OPS		32ULL
#define IRDMA_FEATURE_SRQ			64ULL

#define IRDMAQP_OP_RDMA_WRITE			0x00
#define IRDMAQP_OP_RDMA_READ			0x01
#define IRDMAQP_OP_RDMA_SEND			0x03
#define IRDMAQP_OP_RDMA_SEND_INV		0x04
#define IRDMAQP_OP_RDMA_SEND_SOL_EVENT		0x05
#define IRDMAQP_OP_RDMA_SEND_SOL_EVENT_INV	0x06
#define IRDMAQP_OP_BIND_MW			0x08
#define IRDMAQP_OP_FAST_REGISTER		0x09
#define IRDMAQP_OP_LOCAL_INVALIDATE		0x0a
#define IRDMAQP_OP_RDMA_READ_LOC_INV		0x0b
#define IRDMAQP_OP_NOP				0x0c
#define IRDMAQP_OP_RDMA_WRITE_SOL		0x0d
#define IRDMAQP_OP_GEN_RTS_AE			0x30

#define IRDMA_OP_CEQ_DESTROY			1
#define IRDMA_OP_AEQ_DESTROY			2
#define IRDMA_OP_DELETE_ARP_CACHE_ENTRY		3
#define IRDMA_OP_MANAGE_APBVT_ENTRY		4
#define IRDMA_OP_CEQ_CREATE			5
#define IRDMA_OP_AEQ_CREATE			6
#define IRDMA_OP_MANAGE_QHASH_TABLE_ENTRY	7
#define IRDMA_OP_QP_MODIFY			8
#define IRDMA_OP_QP_UPLOAD_CONTEXT		9
#define IRDMA_OP_CQ_CREATE			10
#define IRDMA_OP_CQ_DESTROY			11
#define IRDMA_OP_QP_CREATE			12
#define IRDMA_OP_QP_DESTROY			13
#define IRDMA_OP_ALLOC_STAG			14
#define IRDMA_OP_MR_REG_NON_SHARED		15
#define IRDMA_OP_DEALLOC_STAG			16
#define IRDMA_OP_MW_ALLOC			17
#define IRDMA_OP_QP_FLUSH_WQES			18
#define IRDMA_OP_ADD_ARP_CACHE_ENTRY		19
#define IRDMA_OP_MANAGE_PUSH_PAGE		20
#define IRDMA_OP_UPDATE_PE_SDS			21
#define IRDMA_OP_MANAGE_HMC_PM_FUNC_TABLE	22
#define IRDMA_OP_SUSPEND			23
#define IRDMA_OP_RESUME				24
#define IRDMA_OP_MANAGE_VF_PBLE_BP		25
#define IRDMA_OP_QUERY_FPM_VAL			26
#define IRDMA_OP_COMMIT_FPM_VAL			27
#define IRDMA_OP_REQ_CMDS			28
#define IRDMA_OP_CMPL_CMDS			29
#define IRDMA_OP_AH_CREATE			30
#define IRDMA_OP_AH_MODIFY			31
#define IRDMA_OP_AH_DESTROY			32
#define IRDMA_OP_MC_CREATE			33
#define IRDMA_OP_MC_DESTROY			34
#define IRDMA_OP_MC_MODIFY			35
#define IRDMA_OP_STATS_ALLOCATE			36
#define IRDMA_OP_STATS_FREE			37
#define IRDMA_OP_STATS_GATHER			38
#define IRDMA_OP_WS_ADD_NODE			39
#define IRDMA_OP_WS_MODIFY_NODE			40
#define IRDMA_OP_WS_DELETE_NODE			41
#define IRDMA_OP_SET_UP_MAP			42
#define IRDMA_OP_GEN_AE				43
#define IRDMA_OP_QUERY_RDMA_FEATURES		44
#define IRDMA_OP_ALLOC_LOCAL_MAC_ENTRY		45
#define IRDMA_OP_ADD_LOCAL_MAC_ENTRY		46
#define IRDMA_OP_DELETE_LOCAL_MAC_ENTRY		47
#define IRDMA_OP_CQ_MODIFY			48
#define IRDMA_OP_SIZE_CQP_STAT_ARRAY		49

#define IRDMA_CQP_OP_CREATE_QP				0
#define IRDMA_CQP_OP_MODIFY_QP				0x1
#define IRDMA_CQP_OP_DESTROY_QP				0x02
#define IRDMA_CQP_OP_CREATE_CQ				0x03
#define IRDMA_CQP_OP_MODIFY_CQ				0x04
#define IRDMA_CQP_OP_DESTROY_CQ				0x05
#define IRDMA_CQP_OP_ALLOC_STAG				0x09
#define IRDMA_CQP_OP_REG_MR				0x0a
#define IRDMA_CQP_OP_QUERY_STAG				0x0b
#define IRDMA_CQP_OP_REG_SMR				0x0c
#define IRDMA_CQP_OP_DEALLOC_STAG			0x0d
#define IRDMA_CQP_OP_MANAGE_LOC_MAC_TABLE		0x0e
#define IRDMA_CQP_OP_MANAGE_ARP				0x0f
#define IRDMA_CQP_OP_MANAGE_VF_PBLE_BP			0x10
#define IRDMA_CQP_OP_MANAGE_PUSH_PAGES			0x11
#define IRDMA_CQP_OP_QUERY_RDMA_FEATURES		0x12
#define IRDMA_CQP_OP_UPLOAD_CONTEXT			0x13
#define IRDMA_CQP_OP_ALLOCATE_LOC_MAC_TABLE_ENTRY	0x14
#define IRDMA_CQP_OP_UPLOAD_CONTEXT			0x13
#define IRDMA_CQP_OP_MANAGE_HMC_PM_FUNC_TABLE		0x15
#define IRDMA_CQP_OP_CREATE_CEQ				0x16
#define IRDMA_CQP_OP_DESTROY_CEQ			0x18
#define IRDMA_CQP_OP_CREATE_AEQ				0x19
#define IRDMA_CQP_OP_DESTROY_AEQ			0x1b
#define IRDMA_CQP_OP_CREATE_ADDR_HANDLE			0x1c
#define IRDMA_CQP_OP_MODIFY_ADDR_HANDLE			0x1d
#define IRDMA_CQP_OP_DESTROY_ADDR_HANDLE		0x1e
#define IRDMA_CQP_OP_UPDATE_PE_SDS			0x1f
#define IRDMA_CQP_OP_QUERY_FPM_VAL			0x20
#define IRDMA_CQP_OP_COMMIT_FPM_VAL			0x21
#define IRDMA_CQP_OP_FLUSH_WQES				0x22
/* IRDMA_CQP_OP_GEN_AE is the same value as IRDMA_CQP_OP_FLUSH_WQES */
#define IRDMA_CQP_OP_GEN_AE				0x22
#define IRDMA_CQP_OP_MANAGE_APBVT			0x23
#define IRDMA_CQP_OP_NOP				0x24
#define IRDMA_CQP_OP_MANAGE_QUAD_HASH_TABLE_ENTRY	0x25
#define IRDMA_CQP_OP_CREATE_MCAST_GRP			0x26
#define IRDMA_CQP_OP_MODIFY_MCAST_GRP			0x27
#define IRDMA_CQP_OP_DESTROY_MCAST_GRP			0x28
#define IRDMA_CQP_OP_SUSPEND_QP				0x29
#define IRDMA_CQP_OP_RESUME_QP				0x2a
#define IRDMA_CQP_OP_SHMC_PAGES_ALLOCATED		0x2b
#define IRDMA_CQP_OP_WORK_SCHED_NODE			0x2c
#define IRDMA_CQP_OP_MANAGE_STATS			0x2d
#define IRDMA_CQP_OP_GATHER_STATS			0x2e
#define IRDMA_CQP_OP_UP_MAP				0x2f

/* Async Events codes */
#define IRDMA_AE_AMP_UNALLOCATED_STAG					0x0102
#define IRDMA_AE_AMP_INVALID_STAG					0x0103
#define IRDMA_AE_AMP_BAD_QP						0x0104
#define IRDMA_AE_AMP_BAD_PD						0x0105
#define IRDMA_AE_AMP_BAD_STAG_KEY					0x0106
#define IRDMA_AE_AMP_BAD_STAG_INDEX					0x0107
#define IRDMA_AE_AMP_BOUNDS_VIOLATION					0x0108
#define IRDMA_AE_AMP_RIGHTS_VIOLATION					0x0109
#define IRDMA_AE_AMP_TO_WRAP						0x010a
#define IRDMA_AE_AMP_FASTREG_VALID_STAG					0x010c
#define IRDMA_AE_AMP_FASTREG_MW_STAG					0x010d
#define IRDMA_AE_AMP_FASTREG_INVALID_RIGHTS				0x010e
#define IRDMA_AE_AMP_FASTREG_INVALID_LENGTH				0x0110
#define IRDMA_AE_AMP_INVALIDATE_SHARED					0x0111
#define IRDMA_AE_AMP_INVALIDATE_NO_REMOTE_ACCESS_RIGHTS			0x0112
#define IRDMA_AE_AMP_INVALIDATE_MR_WITH_BOUND_WINDOWS			0x0113
#define IRDMA_AE_AMP_MWBIND_VALID_STAG					0x0114
#define IRDMA_AE_AMP_MWBIND_OF_MR_STAG					0x0115
#define IRDMA_AE_AMP_MWBIND_TO_ZERO_BASED_STAG				0x0116
#define IRDMA_AE_AMP_MWBIND_TO_MW_STAG					0x0117
#define IRDMA_AE_AMP_MWBIND_INVALID_RIGHTS				0x0118
#define IRDMA_AE_AMP_MWBIND_INVALID_BOUNDS				0x0119
#define IRDMA_AE_AMP_MWBIND_TO_INVALID_PARENT				0x011a
#define IRDMA_AE_AMP_MWBIND_BIND_DISABLED				0x011b
#define IRDMA_AE_PRIV_OPERATION_DENIED					0x011c
#define IRDMA_AE_AMP_INVALIDATE_TYPE1_MW				0x011d
#define IRDMA_AE_AMP_MWBIND_ZERO_BASED_TYPE1_MW				0x011e
#define IRDMA_AE_AMP_FASTREG_INVALID_PBL_HPS_CFG			0x011f
#define IRDMA_AE_AMP_MWBIND_WRONG_TYPE					0x0120
#define IRDMA_AE_AMP_FASTREG_PBLE_MISMATCH				0x0121
#define IRDMA_AE_UDA_XMIT_DGRAM_TOO_LONG				0x0132
#define IRDMA_AE_UDA_XMIT_BAD_PD					0x0133
#define IRDMA_AE_UDA_XMIT_DGRAM_TOO_SHORT				0x0134
#define IRDMA_AE_UDA_L4LEN_INVALID					0x0135
#define IRDMA_AE_BAD_CLOSE						0x0201
#define IRDMA_AE_RDMAP_ROE_BAD_LLP_CLOSE				0x0202
#define IRDMA_AE_CQ_OPERATION_ERROR					0x0203
#define IRDMA_AE_RDMA_READ_WHILE_ORD_ZERO				0x0205
#define IRDMA_AE_STAG_ZERO_INVALID					0x0206
#define IRDMA_AE_IB_RREQ_AND_Q1_FULL					0x0207
#define IRDMA_AE_IB_INVALID_REQUEST					0x0208
#define IRDMA_AE_WQE_UNEXPECTED_OPCODE					0x020a
#define IRDMA_AE_WQE_INVALID_PARAMETER					0x020b
#define IRDMA_AE_WQE_INVALID_FRAG_DATA					0x020c
#define IRDMA_AE_IB_REMOTE_ACCESS_ERROR					0x020d
#define IRDMA_AE_IB_REMOTE_OP_ERROR					0x020e
#define IRDMA_AE_WQE_LSMM_TOO_LONG					0x0220
#define IRDMA_AE_DDP_INVALID_MSN_GAP_IN_MSN				0x0301
#define IRDMA_AE_DDP_UBE_DDP_MESSAGE_TOO_LONG_FOR_AVAILABLE_BUFFER	0x0303
#define IRDMA_AE_DDP_UBE_INVALID_DDP_VERSION				0x0304
#define IRDMA_AE_DDP_UBE_INVALID_MO					0x0305
#define IRDMA_AE_DDP_UBE_INVALID_MSN_NO_BUFFER_AVAILABLE		0x0306
#define IRDMA_AE_DDP_UBE_INVALID_QN					0x0307
#define IRDMA_AE_DDP_NO_L_BIT						0x0308
#define IRDMA_AE_RDMAP_ROE_INVALID_RDMAP_VERSION			0x0311
#define IRDMA_AE_RDMAP_ROE_UNEXPECTED_OPCODE				0x0312
#define IRDMA_AE_ROE_INVALID_RDMA_READ_REQUEST				0x0313
#define IRDMA_AE_ROE_INVALID_RDMA_WRITE_OR_READ_RESP			0x0314
#define IRDMA_AE_ROCE_RSP_LENGTH_ERROR					0x0316
#define IRDMA_AE_ROCE_EMPTY_MCG						0x0380
#define IRDMA_AE_ROCE_BAD_MC_IP_ADDR					0x0381
#define IRDMA_AE_ROCE_BAD_MC_QPID					0x0382
#define IRDMA_AE_MCG_QP_PROTOCOL_MISMATCH				0x0383
#define IRDMA_AE_INVALID_ARP_ENTRY					0x0401
#define IRDMA_AE_INVALID_TCP_OPTION_RCVD				0x0402
#define IRDMA_AE_STALE_ARP_ENTRY					0x0403
#define IRDMA_AE_INVALID_AH_ENTRY					0x0406
#define IRDMA_AE_LLP_CLOSE_COMPLETE					0x0501
#define IRDMA_AE_LLP_CONNECTION_RESET					0x0502
#define IRDMA_AE_LLP_FIN_RECEIVED					0x0503
#define IRDMA_AE_LLP_RECEIVED_MARKER_AND_LENGTH_FIELDS_DONT_MATCH	0x0504
#define IRDMA_AE_LLP_RECEIVED_MPA_CRC_ERROR				0x0505
#define IRDMA_AE_LLP_SEGMENT_TOO_SMALL					0x0507
#define IRDMA_AE_LLP_SYN_RECEIVED					0x0508
#define IRDMA_AE_LLP_TERMINATE_RECEIVED					0x0509
#define IRDMA_AE_LLP_TOO_MANY_RETRIES					0x050a
#define IRDMA_AE_LLP_TOO_MANY_KEEPALIVE_RETRIES				0x050b
#define IRDMA_AE_LLP_DOUBT_REACHABILITY					0x050c
#define IRDMA_AE_LLP_CONNECTION_ESTABLISHED				0x050e
#define IRDMA_AE_RESOURCE_EXHAUSTION					0x0520
#define IRDMA_AE_RESET_SENT						0x0601
#define IRDMA_AE_TERMINATE_SENT						0x0602
#define IRDMA_AE_RESET_NOT_SENT						0x0603
#define IRDMA_AE_LCE_QP_CATASTROPHIC					0x0700
#define IRDMA_AE_LCE_FUNCTION_CATASTROPHIC				0x0701
#define IRDMA_AE_LCE_CQ_CATASTROPHIC					0x0702
#define IRDMA_AE_QP_SUSPEND_COMPLETE					0x0900

#define LS_64_1(val, bits)	((u64)(uintptr_t)(val) << (bits))
#define RS_64_1(val, bits)	((u64)(uintptr_t)(val) >> (bits))
#define LS_32_1(val, bits)	(u32)((val) << (bits))
#define RS_32_1(val, bits)	(u32)((val) >> (bits))
#define LS_64(val, field)	(((u64)(val) << field ## _S) & (field ## _M))
#define RS_64(val, field)	((u64)((val) & field ## _M) >> field ## _S)
#define LS_32(val, field)	(((val) << field ## _S) & (field ## _M))
#define RS_32(val, field)	(((val) & field ## _M) >> field ## _S)

#define FLD_LS_64(dev, val, field)	\
	(((u64)(val) << (dev)->hw_shifts[field ## _S]) & (dev)->hw_masks[field ## _M])
#define FLD_RS_64(dev, val, field)	\
	((u64)((val) & (dev)->hw_masks[field ## _M]) >> (dev)->hw_shifts[field ## _S])
#define FLD_LS_32(dev, val, field)	\
	(((val) << (dev)->hw_shifts[field ## _S]) & (dev)->hw_masks[field ## _M])
#define FLD_RS_32(dev, val, field)	\
	((u64)((val) & (dev)->hw_masks[field ## _M]) >> (dev)->hw_shifts[field ## _S])

#define FW_MAJOR_VER(dev)	\
	((u16)RS_64((dev)->feature_info[IRDMA_FEATURE_FW_INFO], IRDMA_FW_VER_MAJOR))
#define FW_MINOR_VER(dev)	\
	((u16)RS_64((dev)->feature_info[IRDMA_FEATURE_FW_INFO], IRDMA_FW_VER_MINOR))

#define IRDMA_STATS_DELTA(a, b, c) ((a) >= (b) ? (a) - (b) : (a) + (c) - (b))
#define IRDMA_MAX_STATS_32	0xFFFFFFFFULL
#define IRDMA_MAX_STATS_48	0xFFFFFFFFFFFFULL

#define IRDMA_MAX_CQ_READ_THRESH 0x3FFFF
/* ILQ CQP hash table fields */
#define IRDMA_CQPSQ_QHASH_VLANID_S 32
#define IRDMA_CQPSQ_QHASH_VLANID_M \
	((u64)0xfff << IRDMA_CQPSQ_QHASH_VLANID_S)

#define IRDMA_CQPSQ_QHASH_QPN_S 32
#define IRDMA_CQPSQ_QHASH_QPN_M \
	((u64)0x3ffff << IRDMA_CQPSQ_QHASH_QPN_S)

#define IRDMA_CQPSQ_QHASH_QS_HANDLE_S 0
#define IRDMA_CQPSQ_QHASH_QS_HANDLE_M ((u64)0x3ff << IRDMA_CQPSQ_QHASH_QS_HANDLE_S)

#define IRDMA_CQPSQ_QHASH_SRC_PORT_S 16
#define IRDMA_CQPSQ_QHASH_SRC_PORT_M \
	((u64)0xffff << IRDMA_CQPSQ_QHASH_SRC_PORT_S)

#define IRDMA_CQPSQ_QHASH_DEST_PORT_S 0
#define IRDMA_CQPSQ_QHASH_DEST_PORT_M \
	((u64)0xffff << IRDMA_CQPSQ_QHASH_DEST_PORT_S)

#define IRDMA_CQPSQ_QHASH_ADDR0_S 32
#define IRDMA_CQPSQ_QHASH_ADDR0_M \
	((u64)0xffffffff << IRDMA_CQPSQ_QHASH_ADDR0_S)

#define IRDMA_CQPSQ_QHASH_ADDR1_S 0
#define IRDMA_CQPSQ_QHASH_ADDR1_M \
	((u64)0xffffffff << IRDMA_CQPSQ_QHASH_ADDR1_S)

#define IRDMA_CQPSQ_QHASH_ADDR2_S 32
#define IRDMA_CQPSQ_QHASH_ADDR2_M \
	((u64)0xffffffff << IRDMA_CQPSQ_QHASH_ADDR2_S)

#define IRDMA_CQPSQ_QHASH_ADDR3_S 0
#define IRDMA_CQPSQ_QHASH_ADDR3_M \
	((u64)0xffffffff << IRDMA_CQPSQ_QHASH_ADDR3_S)

#define IRDMA_CQPSQ_QHASH_WQEVALID_S 63
#define IRDMA_CQPSQ_QHASH_WQEVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QHASH_WQEVALID_S)
#define IRDMA_CQPSQ_QHASH_OPCODE_S 32
#define IRDMA_CQPSQ_QHASH_OPCODE_M \
	((u64)0x3f << IRDMA_CQPSQ_QHASH_OPCODE_S)

#define IRDMA_CQPSQ_QHASH_MANAGE_S 61
#define IRDMA_CQPSQ_QHASH_MANAGE_M \
	((u64)0x3 << IRDMA_CQPSQ_QHASH_MANAGE_S)

#define IRDMA_CQPSQ_QHASH_IPV4VALID_S 60
#define IRDMA_CQPSQ_QHASH_IPV4VALID_M \
	BIT_ULL(IRDMA_CQPSQ_QHASH_IPV4VALID_S)

#define IRDMA_CQPSQ_QHASH_VLANVALID_S 59
#define IRDMA_CQPSQ_QHASH_VLANVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QHASH_VLANVALID_S)

#define IRDMA_CQPSQ_QHASH_ENTRYTYPE_S 42
#define IRDMA_CQPSQ_QHASH_ENTRYTYPE_M \
	((u64)0x7 << IRDMA_CQPSQ_QHASH_ENTRYTYPE_S)

/* Stats */
#define IRDMA_CQPSQ_STATS_WQEVALID_S 63
#define IRDMA_CQPSQ_STATS_WQEVALID_M \
	BIT_ULL(IRDMA_CQPSQ_STATS_WQEVALID_S)

#define IRDMA_CQPSQ_STATS_ALLOC_INST_S 62
#define IRDMA_CQPSQ_STATS_ALLOC_INST_M \
	BIT_ULL(IRDMA_CQPSQ_STATS_ALLOC_INST_S)

#define IRDMA_CQPSQ_STATS_USE_HMC_FCN_INDEX_S 60
#define IRDMA_CQPSQ_STATS_USE_HMC_FCN_INDEX_M \
	BIT_ULL(IRDMA_CQPSQ_STATS_USE_HMC_FCN_INDEX_S)

#define IRDMA_CQPSQ_STATS_USE_INST_S 61
#define IRDMA_CQPSQ_STATS_USE_INST_M \
	BIT_ULL(IRDMA_CQPSQ_STATS_USE_INST_S)

#define IRDMA_CQPSQ_STATS_OP_S 32
#define IRDMA_CQPSQ_STATS_OP_M \
	((u64)0x3f << IRDMA_CQPSQ_STATS_OP_S)

#define IRDMA_CQPSQ_STATS_INST_INDEX_S 0
#define IRDMA_CQPSQ_STATS_INST_INDEX_M \
	((u64)0x7f << IRDMA_CQPSQ_STATS_INST_INDEX_S)

#define IRDMA_CQPSQ_STATS_HMC_FCN_INDEX_S 0
#define IRDMA_CQPSQ_STATS_HMC_FCN_INDEX_M \
	((u64)0x3f << IRDMA_CQPSQ_STATS_HMC_FCN_INDEX_S)

/* WS - Work Scheduler */
#define IRDMA_CQPSQ_WS_WQEVALID_S 63
#define IRDMA_CQPSQ_WS_WQEVALID_M \
	BIT_ULL(IRDMA_CQPSQ_WS_WQEVALID_S)

#define IRDMA_CQPSQ_WS_NODEOP_S 52
#define IRDMA_CQPSQ_WS_NODEOP_M \
	((u64)0x3 << IRDMA_CQPSQ_WS_NODEOP_S)

#define IRDMA_CQPSQ_WS_ENABLENODE_S 62
#define IRDMA_CQPSQ_WS_ENABLENODE_M \
	BIT_ULL(IRDMA_CQPSQ_WS_ENABLENODE_S)

#define IRDMA_CQPSQ_WS_NODETYPE_S 61
#define IRDMA_CQPSQ_WS_NODETYPE_M \
	BIT_ULL(IRDMA_CQPSQ_WS_NODETYPE_S)

#define IRDMA_CQPSQ_WS_PRIOTYPE_S 59
#define IRDMA_CQPSQ_WS_PRIOTYPE_M \
	((u64)0x3 << IRDMA_CQPSQ_WS_PRIOTYPE_S)

#define IRDMA_CQPSQ_WS_TC_S 56
#define IRDMA_CQPSQ_WS_TC_M \
	((u64)0x7 << IRDMA_CQPSQ_WS_TC_S)

#define IRDMA_CQPSQ_WS_VMVFTYPE_S 54
#define IRDMA_CQPSQ_WS_VMVFTYPE_M \
	((u64)0x3 << IRDMA_CQPSQ_WS_VMVFTYPE_S)

#define IRDMA_CQPSQ_WS_VMVFNUM_S 42
#define IRDMA_CQPSQ_WS_VMVFNUM_M \
	((u64)0x3ff << IRDMA_CQPSQ_WS_VMVFNUM_S)

#define IRDMA_CQPSQ_WS_OP_S 32
#define IRDMA_CQPSQ_WS_OP_M \
	((u64)0x3f << IRDMA_CQPSQ_WS_OP_S)

#define IRDMA_CQPSQ_WS_PARENTID_S 16
#define IRDMA_CQPSQ_WS_PARENTID_M \
	((u64)0x3ff << IRDMA_CQPSQ_WS_PARENTID_S)

#define IRDMA_CQPSQ_WS_NODEID_S 0
#define IRDMA_CQPSQ_WS_NODEID_M \
	((u64)0x3ff << IRDMA_CQPSQ_WS_NODEID_S)

#define IRDMA_CQPSQ_WS_VSI_S 48
#define IRDMA_CQPSQ_WS_VSI_M \
	((u64)0x3ff << IRDMA_CQPSQ_WS_VSI_S)

#define IRDMA_CQPSQ_WS_WEIGHT_S 32
#define IRDMA_CQPSQ_WS_WEIGHT_M \
	((u64)0x7f << IRDMA_CQPSQ_WS_WEIGHT_S)

/* UP to UP mapping */
#define IRDMA_CQPSQ_UP_WQEVALID_S 63
#define IRDMA_CQPSQ_UP_WQEVALID_M \
	BIT_ULL(IRDMA_CQPSQ_UP_WQEVALID_S)

#define IRDMA_CQPSQ_UP_USEVLAN_S 62
#define IRDMA_CQPSQ_UP_USEVLAN_M \
	BIT_ULL(IRDMA_CQPSQ_UP_USEVLAN_S)

#define IRDMA_CQPSQ_UP_USEOVERRIDE_S 61
#define IRDMA_CQPSQ_UP_USEOVERRIDE_M \
	BIT_ULL(IRDMA_CQPSQ_UP_USEOVERRIDE_S)

#define IRDMA_CQPSQ_UP_OP_S 32
#define IRDMA_CQPSQ_UP_OP_M \
	((u64)0x3f << IRDMA_CQPSQ_UP_OP_S)

#define IRDMA_CQPSQ_UP_HMCFCNIDX_S 0
#define IRDMA_CQPSQ_UP_HMCFCNIDX_M \
	((u64)0x3f << IRDMA_CQPSQ_UP_HMCFCNIDX_S)

#define IRDMA_CQPSQ_UP_CNPOVERRIDE_S 32
#define IRDMA_CQPSQ_UP_CNPOVERRIDE_M \
	((u64)0x3f << IRDMA_CQPSQ_UP_CNPOVERRIDE_S)

/* Query RDMA features*/
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_WQEVALID_S 63
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_WQEVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QUERY_RDMA_FEATURES_WQEVALID_S)

#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_BUF_LEN_S 0
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_BUF_LEN_M \
	((u64)0xffffffff << IRDMA_CQPSQ_QUERY_RDMA_FEATURES_BUF_LEN_S)

#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_OP_S 32
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_OP_M \
	((u64)0x3f << IRDMA_CQPSQ_QUERY_RDMA_FEATURES_OP_S)

#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MODEL_USED_S 32
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MODEL_USED_M \
	(0xffffULL << IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MODEL_USED_S)

#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MAJOR_VERSION_S 16
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MAJOR_VERSION_M \
	(0xffULL << IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MAJOR_VERSION_S)

#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MINOR_VERSION_S 0
#define IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MINOR_VERSION_M \
	(0xffULL << IRDMA_CQPSQ_QUERY_RDMA_FEATURES_HW_MINOR_VERSION_S)

/* CQP Host Context */
#define IRDMA_CQPHC_SQSIZE_S 8
#define IRDMA_CQPHC_SQSIZE_M (0xfULL << IRDMA_CQPHC_SQSIZE_S)

#define IRDMA_CQPHC_DISABLE_PFPDUS_S 1
#define IRDMA_CQPHC_DISABLE_PFPDUS_M BIT_ULL(IRDMA_CQPHC_DISABLE_PFPDUS_S)

#define IRDMA_CQPHC_ROCEV2_RTO_POLICY_S 2
#define IRDMA_CQPHC_ROCEV2_RTO_POLICY_M BIT_ULL(IRDMA_CQPHC_ROCEV2_RTO_POLICY_S)

#define IRDMA_CQPHC_PROTOCOL_USED_S 3
#define IRDMA_CQPHC_PROTOCOL_USED_M (0x3ULL << IRDMA_CQPHC_PROTOCOL_USED_S)

#define IRDMA_CQPHC_MIN_RATE_S 48
#define IRDMA_CQPHC_MIN_RATE_M (0xfULL << IRDMA_CQPHC_MIN_RATE_S)

#define IRDMA_CQPHC_MIN_DEC_FACTOR_S 56
#define IRDMA_CQPHC_MIN_DEC_FACTOR_M (0xfULL << IRDMA_CQPHC_MIN_DEC_FACTOR_S)

#define IRDMA_CQPHC_DCQCN_T_S 0
#define IRDMA_CQPHC_DCQCN_T_M (0xffffULL << IRDMA_CQPHC_DCQCN_T_S)

#define IRDMA_CQPHC_HAI_FACTOR_S 32
#define IRDMA_CQPHC_HAI_FACTOR_M \
	(0xffffULL << IRDMA_CQPHC_HAI_FACTOR_S)

#define IRDMA_CQPHC_RAI_FACTOR_S 48
#define IRDMA_CQPHC_RAI_FACTOR_M \
	(0xffffULL << IRDMA_CQPHC_RAI_FACTOR_S)

#define IRDMA_CQPHC_DCQCN_B_S 0
#define IRDMA_CQPHC_DCQCN_B_M (0x1ffffffULL << IRDMA_CQPHC_DCQCN_B_S)

#define IRDMA_CQPHC_DCQCN_F_S 25
#define IRDMA_CQPHC_DCQCN_F_M (0x7ULL << IRDMA_CQPHC_DCQCN_F_S)

#define IRDMA_CQPHC_CC_CFG_VALID_S 31
#define IRDMA_CQPHC_CC_CFG_VALID_M BIT_ULL(IRDMA_CQPHC_CC_CFG_VALID_S)

#define IRDMA_CQPHC_RREDUCE_MPERIOD_S 32
#define IRDMA_CQPHC_RREDUCE_MPERIOD_M \
	(0xffffffffULL << IRDMA_CQPHC_RREDUCE_MPERIOD_S)

#define IRDMA_CQPHC_HW_MINVER_S 0
#define IRDMA_CQPHC_HW_MINVER_M (0xffffULL << IRDMA_CQPHC_HW_MINVER_S)

#define IRDMA_CQPHC_HW_MAJVER_GEN_1 0
#define IRDMA_CQPHC_HW_MAJVER_GEN_2 1
#define IRDMA_CQPHC_HW_MAJVER_GEN_3 2

#define IRDMA_CQPHC_HW_MAJVER_S 16
#define IRDMA_CQPHC_HW_MAJVER_M (0xffffULL << IRDMA_CQPHC_HW_MAJVER_S)

#define IRDMA_CQPHC_CEQPERVF_S 32
#define IRDMA_CQPHC_CEQPERVF_M (0xffULL << IRDMA_CQPHC_CEQPERVF_S)

#define IRDMA_CQPHC_EN_REM_ENDPOINT_TRK_S 3
#define IRDMA_CQPHC_EN_REM_ENDPOINT_TRK_M BIT_ULL(IRDMA_CQPHC_EN_REM_ENDPOINT_TRK_S)

#define IRDMA_CQPHC_ENABLED_VFS_S 32
#define IRDMA_CQPHC_ENABLED_VFS_M (0x3fULL << IRDMA_CQPHC_ENABLED_VFS_S)

#define IRDMA_CQPHC_HMC_PROFILE_S 0
#define IRDMA_CQPHC_HMC_PROFILE_M (0x7ULL << IRDMA_CQPHC_HMC_PROFILE_S)

#define IRDMA_CQPHC_SVER_S 24
#define IRDMA_CQPHC_SVER_M (0xffULL << IRDMA_CQPHC_SVER_S)

#define IRDMA_CQPHC_SQBASE_S 9
#define IRDMA_CQPHC_SQBASE_M \
	(0xfffffffffffffeULL << IRDMA_CQPHC_SQBASE_S)

#define IRDMA_CQPHC_QPCTX_S 0
#define IRDMA_CQPHC_QPCTX_M \
	(0xffffffffffffffffULL << IRDMA_CQPHC_QPCTX_S)

/* iWARP QP Doorbell shadow area */
#define IRDMA_QP_DBSA_HW_SQ_TAIL_S 0
#define IRDMA_QP_DBSA_HW_SQ_TAIL_M \
	(0x7fffULL << IRDMA_QP_DBSA_HW_SQ_TAIL_S)

/* Completion Queue Doorbell shadow area */
#define IRDMA_CQ_DBSA_CQEIDX_S 0
#define IRDMA_CQ_DBSA_CQEIDX_M (0xfffffULL << IRDMA_CQ_DBSA_CQEIDX_S)

#define IRDMA_CQ_DBSA_SW_CQ_SELECT_S 0
#define IRDMA_CQ_DBSA_SW_CQ_SELECT_M \
	(0x3fffULL << IRDMA_CQ_DBSA_SW_CQ_SELECT_S)

#define IRDMA_CQ_DBSA_ARM_NEXT_S 14
#define IRDMA_CQ_DBSA_ARM_NEXT_M BIT_ULL(IRDMA_CQ_DBSA_ARM_NEXT_S)

#define IRDMA_CQ_DBSA_ARM_NEXT_SE_S 15
#define IRDMA_CQ_DBSA_ARM_NEXT_SE_M BIT_ULL(IRDMA_CQ_DBSA_ARM_NEXT_SE_S)

#define IRDMA_CQ_DBSA_ARM_SEQ_NUM_S 16
#define IRDMA_CQ_DBSA_ARM_SEQ_NUM_M \
	(0x3ULL << IRDMA_CQ_DBSA_ARM_SEQ_NUM_S)

/* CQP and iWARP Completion Queue */
#define IRDMA_CQ_QPCTX_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQ_QPCTX_M IRDMA_CQPHC_QPCTX_M

#define IRDMA_CCQ_OPRETVAL_S 0
#define IRDMA_CCQ_OPRETVAL_M (0xffffffffULL << IRDMA_CCQ_OPRETVAL_S)

#define IRDMA_CQ_MINERR_S 0
#define IRDMA_CQ_MINERR_M (0xffffULL << IRDMA_CQ_MINERR_S)

#define IRDMA_CQ_MAJERR_S 16
#define IRDMA_CQ_MAJERR_M (0xffffULL << IRDMA_CQ_MAJERR_S)

#define IRDMA_CQ_WQEIDX_S 32
#define IRDMA_CQ_WQEIDX_M (0x7fffULL << IRDMA_CQ_WQEIDX_S)

#define IRDMA_CQ_EXTCQE_S 50
#define IRDMA_CQ_EXTCQE_M BIT_ULL(IRDMA_CQ_EXTCQE_S)

#define IRDMA_OOO_CMPL_S 54
#define IRDMA_OOO_CMPL_M BIT_ULL(IRDMA_OOO_CMPL_S)

#define IRDMA_CQ_ERROR_S 55
#define IRDMA_CQ_ERROR_M BIT_ULL(IRDMA_CQ_ERROR_S)

#define IRDMA_CQ_SQ_S 62
#define IRDMA_CQ_SQ_M BIT_ULL(IRDMA_CQ_SQ_S)

#define IRDMA_CQ_VALID_S 63
#define IRDMA_CQ_VALID_M BIT_ULL(IRDMA_CQ_VALID_S)

#define IRDMA_CQ_IMMVALID_S 62
#define IRDMA_CQ_IMMVALID_M BIT_ULL(IRDMA_CQ_IMMVALID_S)

#define IRDMA_CQ_UDSMACVALID_S 61
#define IRDMA_CQ_UDSMACVALID_M BIT_ULL(IRDMA_CQ_UDSMACVALID_S)

#define IRDMA_CQ_UDVLANVALID_S 60
#define IRDMA_CQ_UDVLANVALID_M BIT_ULL(IRDMA_CQ_UDVLANVALID_S)

#define IRDMA_CQ_UDSMAC_S 0
#define IRDMA_CQ_UDSMAC_M (0xffffffffffffULL << IRDMA_CQ_UDSMAC_S)

#define IRDMA_CQ_UDVLAN_S 48
#define IRDMA_CQ_UDVLAN_M (0xffffULL << IRDMA_CQ_UDVLAN_S)

#define IRDMA_CQ_IMMDATA_S 0
#define IRDMA_CQ_IMMDATA_M (0xffffffffffffffffULL << IRDMA_CQ_IMMVALID_S)

#define IRDMA_CQ_IMMDATALOW32_S 0
#define IRDMA_CQ_IMMDATALOW32_M (0xffffffffULL << IRDMA_CQ_IMMDATALOW32_S)

#define IRDMA_CQ_IMMDATAUP32_S 32
#define IRDMA_CQ_IMMDATAUP32_M (0xffffffffULL << IRDMA_CQ_IMMDATAUP32_S)

#define IRDMACQ_PAYLDLEN_S 0
#define IRDMACQ_PAYLDLEN_M (0xffffffffULL << IRDMACQ_PAYLDLEN_S)

#define IRDMACQ_TCPSEQNUMRTT_S 32
#define IRDMACQ_TCPSEQNUMRTT_M (0xffffffffULL << IRDMACQ_TCPSEQNUMRTT_S)

#define IRDMACQ_INVSTAG_S 0
#define IRDMACQ_INVSTAG_M (0xffffffffULL << IRDMACQ_INVSTAG_S)

#define IRDMACQ_QPID_S 32
#define IRDMACQ_QPID_M (0xffffffULL << IRDMACQ_QPID_S)

#define IRDMACQ_UDSRCQPN_S 0
#define IRDMACQ_UDSRCQPN_M (0xffffffffULL << IRDMACQ_UDSRCQPN_S)

#define IRDMACQ_PSHDROP_S 51
#define IRDMACQ_PSHDROP_M BIT_ULL(IRDMACQ_PSHDROP_S)

#define IRDMACQ_STAG_S 53
#define IRDMACQ_STAG_M BIT_ULL(IRDMACQ_STAG_S)

#define IRDMACQ_IPV4_S 53
#define IRDMACQ_IPV4_M BIT_ULL(IRDMACQ_IPV4_S)

#define IRDMACQ_SOEVENT_S 54
#define IRDMACQ_SOEVENT_M BIT_ULL(IRDMACQ_SOEVENT_S)

#define IRDMACQ_OP_S 56
#define IRDMACQ_OP_M (0x3fULL << IRDMACQ_OP_S)

/* CEQE format */
#define IRDMA_CEQE_CQCTX_S 0
#define IRDMA_CEQE_CQCTX_M \
	(0x7fffffffffffffffULL << IRDMA_CEQE_CQCTX_S)

#define IRDMA_CEQE_VALID_S 63
#define IRDMA_CEQE_VALID_M BIT_ULL(IRDMA_CEQE_VALID_S)

/* AEQE format */
#define IRDMA_AEQE_COMPCTX_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_AEQE_COMPCTX_M IRDMA_CQPHC_QPCTX_M

#define IRDMA_AEQE_QPCQID_LOW_S 0
#define IRDMA_AEQE_QPCQID_LOW_M (0x3ffffULL << IRDMA_AEQE_QPCQID_LOW_S)

#define IRDMA_AEQE_QPCQID_HI_S 46
#define IRDMA_AEQE_QPCQID_HI_M BIT_ULL(IRDMA_AEQE_QPCQID_HI_S)

#define IRDMA_AEQE_WQDESCIDX_S 18
#define IRDMA_AEQE_WQDESCIDX_M (0x7fffULL << IRDMA_AEQE_WQDESCIDX_S)

#define IRDMA_AEQE_OVERFLOW_S 33
#define IRDMA_AEQE_OVERFLOW_M BIT_ULL(IRDMA_AEQE_OVERFLOW_S)

#define IRDMA_AEQE_AECODE_S 34
#define IRDMA_AEQE_AECODE_M (0xfffULL << IRDMA_AEQE_AECODE_S)

#define IRDMA_AEQE_AESRC_S 50
#define IRDMA_AEQE_AESRC_M (0xfULL << IRDMA_AEQE_AESRC_S)

#define IRDMA_AEQE_IWSTATE_S 54
#define IRDMA_AEQE_IWSTATE_M (0x7ULL << IRDMA_AEQE_IWSTATE_S)

#define IRDMA_AEQE_TCPSTATE_S 57
#define IRDMA_AEQE_TCPSTATE_M (0xfULL << IRDMA_AEQE_TCPSTATE_S)

#define IRDMA_AEQE_Q2DATA_S 61
#define IRDMA_AEQE_Q2DATA_M (0x3ULL << IRDMA_AEQE_Q2DATA_S)

#define IRDMA_AEQE_VALID_S 63
#define IRDMA_AEQE_VALID_M BIT_ULL(IRDMA_AEQE_VALID_S)

#define IRDMA_UDA_QPSQ_NEXT_HDR_S 16
#define IRDMA_UDA_QPSQ_NEXT_HDR_M ((u64)0xff << IRDMA_UDA_QPSQ_NEXT_HDR_S)

#define IRDMA_UDA_QPSQ_OPCODE_S 32
#define IRDMA_UDA_QPSQ_OPCODE_M ((u64)0x3f << IRDMA_UDA_QPSQ_OPCODE_S)

#define IRDMA_UDA_QPSQ_L4LEN_S 42
#define IRDMA_UDA_QPSQ_L4LEN_M ((u64)0xf << IRDMA_UDA_QPSQ_L4LEN_S)

#define IRDMA_GEN1_UDA_QPSQ_L4LEN_S 24
#define IRDMA_GEN1_UDA_QPSQ_L4LEN_M ((u64)0xf << IRDMA_GEN1_UDA_QPSQ_L4LEN_S)

#define IRDMA_UDA_QPSQ_AHIDX_S 0
#define IRDMA_UDA_QPSQ_AHIDX_M ((u64)0x1ffff << IRDMA_UDA_QPSQ_AHIDX_S)

#define IRDMA_UDA_QPSQ_VALID_S 63
#define IRDMA_UDA_QPSQ_VALID_M \
	BIT_ULL(IRDMA_UDA_QPSQ_VALID_S)

#define IRDMA_UDA_QPSQ_SIGCOMPL_S 62
#define IRDMA_UDA_QPSQ_SIGCOMPL_M BIT_ULL(IRDMA_UDA_QPSQ_SIGCOMPL_S)

#define IRDMA_UDA_QPSQ_MACLEN_S 56
#define IRDMA_UDA_QPSQ_MACLEN_M \
	((u64)0x7f << IRDMA_UDA_QPSQ_MACLEN_S)

#define IRDMA_UDA_QPSQ_IPLEN_S 48
#define IRDMA_UDA_QPSQ_IPLEN_M \
	((u64)0x7f << IRDMA_UDA_QPSQ_IPLEN_S)

#define IRDMA_UDA_QPSQ_L4T_S 30
#define IRDMA_UDA_QPSQ_L4T_M \
	((u64)0x3 << IRDMA_UDA_QPSQ_L4T_S)

#define IRDMA_UDA_QPSQ_IIPT_S 28
#define IRDMA_UDA_QPSQ_IIPT_M \
	((u64)0x3 << IRDMA_UDA_QPSQ_IIPT_S)

#define IRDMA_UDA_PAYLOADLEN_S 0
#define IRDMA_UDA_PAYLOADLEN_M ((u64)0x3fff << IRDMA_UDA_PAYLOADLEN_S)

#define IRDMA_UDA_HDRLEN_S 16
#define IRDMA_UDA_HDRLEN_M ((u64)0x1ff << IRDMA_UDA_HDRLEN_S)

#define IRDMA_VLAN_TAG_VALID_S 50
#define IRDMA_VLAN_TAG_VALID_M BIT_ULL(IRDMA_VLAN_TAG_VALID_S)

#define IRDMA_UDA_L3PROTO_S 0
#define IRDMA_UDA_L3PROTO_M ((u64)0x3 << IRDMA_UDA_L3PROTO_S)

#define IRDMA_UDA_L4PROTO_S 16
#define IRDMA_UDA_L4PROTO_M ((u64)0x3 << IRDMA_UDA_L4PROTO_S)

#define IRDMA_UDA_QPSQ_DOLOOPBACK_S 44
#define IRDMA_UDA_QPSQ_DOLOOPBACK_M \
	BIT_ULL(IRDMA_UDA_QPSQ_DOLOOPBACK_S)

/* CQP SQ WQE common fields */
#define IRDMA_CQPSQ_BUFSIZE_S 0
#define IRDMA_CQPSQ_BUFSIZE_M (0xffffffffULL << IRDMA_CQPSQ_BUFSIZE_S)

#define IRDMA_CQPSQ_OPCODE_S 32
#define IRDMA_CQPSQ_OPCODE_M (0x3fULL << IRDMA_CQPSQ_OPCODE_S)

#define IRDMA_CQPSQ_WQEVALID_S 63
#define IRDMA_CQPSQ_WQEVALID_M BIT_ULL(IRDMA_CQPSQ_WQEVALID_S)

#define IRDMA_CQPSQ_TPHVAL_S 0
#define IRDMA_CQPSQ_TPHVAL_M (0xffULL << IRDMA_CQPSQ_TPHVAL_S)

#define IRDMA_CQPSQ_VSIIDX_S 8
#define IRDMA_CQPSQ_VSIIDX_M (0x3ffULL << IRDMA_CQPSQ_VSIIDX_S)

#define IRDMA_CQPSQ_TPHEN_S 60
#define IRDMA_CQPSQ_TPHEN_M BIT_ULL(IRDMA_CQPSQ_TPHEN_S)

#define IRDMA_CQPSQ_PBUFADDR_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQPSQ_PBUFADDR_M IRDMA_CQPHC_QPCTX_M

/* Create/Modify/Destroy QP */

#define IRDMA_CQPSQ_QP_NEWMSS_S 32
#define IRDMA_CQPSQ_QP_NEWMSS_M (0x3fffULL << IRDMA_CQPSQ_QP_NEWMSS_S)

#define IRDMA_CQPSQ_QP_TERMLEN_S 48
#define IRDMA_CQPSQ_QP_TERMLEN_M (0xfULL << IRDMA_CQPSQ_QP_TERMLEN_S)

#define IRDMA_CQPSQ_QP_QPCTX_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQPSQ_QP_QPCTX_M IRDMA_CQPHC_QPCTX_M

#define IRDMA_CQPSQ_QP_QPID_S 0
#define IRDMA_CQPSQ_QP_QPID_M (0xFFFFFFUL)

#define IRDMA_CQPSQ_QP_OP_S 32
#define IRDMA_CQPSQ_QP_OP_M IRDMACQ_OP_M

#define IRDMA_CQPSQ_QP_ORDVALID_S 42
#define IRDMA_CQPSQ_QP_ORDVALID_M BIT_ULL(IRDMA_CQPSQ_QP_ORDVALID_S)

#define IRDMA_CQPSQ_QP_TOECTXVALID_S 43
#define IRDMA_CQPSQ_QP_TOECTXVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QP_TOECTXVALID_S)

#define IRDMA_CQPSQ_QP_CACHEDVARVALID_S 44
#define IRDMA_CQPSQ_QP_CACHEDVARVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QP_CACHEDVARVALID_S)

#define IRDMA_CQPSQ_QP_VQ_S 45
#define IRDMA_CQPSQ_QP_VQ_M BIT_ULL(IRDMA_CQPSQ_QP_VQ_S)

#define IRDMA_CQPSQ_QP_FORCELOOPBACK_S 46
#define IRDMA_CQPSQ_QP_FORCELOOPBACK_M \
	BIT_ULL(IRDMA_CQPSQ_QP_FORCELOOPBACK_S)

#define IRDMA_CQPSQ_QP_CQNUMVALID_S 47
#define IRDMA_CQPSQ_QP_CQNUMVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QP_CQNUMVALID_S)

#define IRDMA_CQPSQ_QP_QPTYPE_S 48
#define IRDMA_CQPSQ_QP_QPTYPE_M (0x7ULL << IRDMA_CQPSQ_QP_QPTYPE_S)

#define IRDMA_CQPSQ_QP_MACVALID_S 51
#define IRDMA_CQPSQ_QP_MACVALID_M BIT_ULL(IRDMA_CQPSQ_QP_MACVALID_S)

#define IRDMA_CQPSQ_QP_MSSCHANGE_S 52
#define IRDMA_CQPSQ_QP_MSSCHANGE_M BIT_ULL(IRDMA_CQPSQ_QP_MSSCHANGE_S)

#define IRDMA_CQPSQ_QP_IGNOREMWBOUND_S 54
#define IRDMA_CQPSQ_QP_IGNOREMWBOUND_M \
	BIT_ULL(IRDMA_CQPSQ_QP_IGNOREMWBOUND_S)

#define IRDMA_CQPSQ_QP_REMOVEHASHENTRY_S 55
#define IRDMA_CQPSQ_QP_REMOVEHASHENTRY_M \
	BIT_ULL(IRDMA_CQPSQ_QP_REMOVEHASHENTRY_S)

#define IRDMA_CQPSQ_QP_TERMACT_S 56
#define IRDMA_CQPSQ_QP_TERMACT_M (0x3ULL << IRDMA_CQPSQ_QP_TERMACT_S)

#define IRDMA_CQPSQ_QP_RESETCON_S 58
#define IRDMA_CQPSQ_QP_RESETCON_M BIT_ULL(IRDMA_CQPSQ_QP_RESETCON_S)

#define IRDMA_CQPSQ_QP_ARPTABIDXVALID_S 59
#define IRDMA_CQPSQ_QP_ARPTABIDXVALID_M \
	BIT_ULL(IRDMA_CQPSQ_QP_ARPTABIDXVALID_S)

#define IRDMA_CQPSQ_QP_NEXTIWSTATE_S 60
#define IRDMA_CQPSQ_QP_NEXTIWSTATE_M \
	(0x7ULL << IRDMA_CQPSQ_QP_NEXTIWSTATE_S)

#define IRDMA_CQPSQ_QP_DBSHADOWADDR_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQPSQ_QP_DBSHADOWADDR_M IRDMA_CQPHC_QPCTX_M

/* Create/Modify/Destroy CQ */
#define IRDMA_CQPSQ_CQ_CQSIZE_S 0
#define IRDMA_CQPSQ_CQ_CQSIZE_M (0x1fffffULL << IRDMA_CQPSQ_CQ_CQSIZE_S)

#define IRDMA_CQPSQ_CQ_CQCTX_S 0
#define IRDMA_CQPSQ_CQ_CQCTX_M \
	(0x7fffffffffffffffULL << IRDMA_CQPSQ_CQ_CQCTX_S)

#define IRDMA_CQPSQ_CQ_SHADOW_READ_THRESHOLD_S 0
#define IRDMA_CQPSQ_CQ_SHADOW_READ_THRESHOLD_M \
	(0x3ffff << IRDMA_CQPSQ_CQ_SHADOW_READ_THRESHOLD_S)

#define IRDMA_CQPSQ_CQ_OP_S 32
#define IRDMA_CQPSQ_CQ_OP_M (0x3fULL << IRDMA_CQPSQ_CQ_OP_S)

#define IRDMA_CQPSQ_CQ_CQRESIZE_S 43
#define IRDMA_CQPSQ_CQ_CQRESIZE_M BIT_ULL(IRDMA_CQPSQ_CQ_CQRESIZE_S)

#define IRDMA_CQPSQ_CQ_LPBLSIZE_S 44
#define IRDMA_CQPSQ_CQ_LPBLSIZE_M (3ULL << IRDMA_CQPSQ_CQ_LPBLSIZE_S)

#define IRDMA_CQPSQ_CQ_CHKOVERFLOW_S 46
#define IRDMA_CQPSQ_CQ_CHKOVERFLOW_M \
	BIT_ULL(IRDMA_CQPSQ_CQ_CHKOVERFLOW_S)

#define IRDMA_CQPSQ_CQ_VIRTMAP_S 47
#define IRDMA_CQPSQ_CQ_VIRTMAP_M BIT_ULL(IRDMA_CQPSQ_CQ_VIRTMAP_S)

#define IRDMA_CQPSQ_CQ_ENCEQEMASK_S 48
#define IRDMA_CQPSQ_CQ_ENCEQEMASK_M \
	BIT_ULL(IRDMA_CQPSQ_CQ_ENCEQEMASK_S)

#define IRDMA_CQPSQ_CQ_CEQIDVALID_S 49
#define IRDMA_CQPSQ_CQ_CEQIDVALID_M \
	BIT_ULL(IRDMA_CQPSQ_CQ_CEQIDVALID_S)

#define IRDMA_CQPSQ_CQ_AVOIDMEMCNFLCT_S 61
#define IRDMA_CQPSQ_CQ_AVOIDMEMCNFLCT_M \
	BIT_ULL(IRDMA_CQPSQ_CQ_AVOIDMEMCNFLCT_S)

#define IRDMA_CQPSQ_CQ_FIRSTPMPBLIDX_S 0
#define IRDMA_CQPSQ_CQ_FIRSTPMPBLIDX_M \
	(0xfffffffULL << IRDMA_CQPSQ_CQ_FIRSTPMPBLIDX_S)

/* Allocate/Register/Register Shared/Deallocate Stag */
#define IRDMA_CQPSQ_STAG_VA_FBO_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQPSQ_STAG_VA_FBO_M IRDMA_CQPHC_QPCTX_M

#define IRDMA_CQPSQ_STAG_STAGLEN_S 0
#define IRDMA_CQPSQ_STAG_STAGLEN_M \
	(0x3fffffffffffULL << IRDMA_CQPSQ_STAG_STAGLEN_S)

#define IRDMA_CQPSQ_STAG_KEY_S 0
#define IRDMA_CQPSQ_STAG_KEY_M (0xffULL << IRDMA_CQPSQ_STAG_KEY_S)

#define IRDMA_CQPSQ_STAG_IDX_S 8
#define IRDMA_CQPSQ_STAG_IDX_M (0xffffffULL << IRDMA_CQPSQ_STAG_IDX_S)

#define IRDMA_CQPSQ_STAG_PARENTSTAGIDX_S 32
#define IRDMA_CQPSQ_STAG_PARENTSTAGIDX_M \
	(0xffffffULL << IRDMA_CQPSQ_STAG_PARENTSTAGIDX_S)

#define IRDMA_CQPSQ_STAG_MR_S 43
#define IRDMA_CQPSQ_STAG_MR_M BIT_ULL(IRDMA_CQPSQ_STAG_MR_S)

#define IRDMA_CQPSQ_STAG_MWTYPE_S 42
#define IRDMA_CQPSQ_STAG_MWTYPE_M BIT_ULL(IRDMA_CQPSQ_STAG_MWTYPE_S)

#define IRDMA_CQPSQ_STAG_MW1_BIND_DONT_VLDT_KEY_S 58
#define IRDMA_CQPSQ_STAG_MW1_BIND_DONT_VLDT_KEY_M \
	BIT_ULL(IRDMA_CQPSQ_STAG_MW1_BIND_DONT_VLDT_KEY_S)

#define IRDMA_CQPSQ_STAG_LPBLSIZE_S IRDMA_CQPSQ_CQ_LPBLSIZE_S
#define IRDMA_CQPSQ_STAG_LPBLSIZE_M IRDMA_CQPSQ_CQ_LPBLSIZE_M

#define IRDMA_CQPSQ_STAG_HPAGESIZE_S 46
#define IRDMA_CQPSQ_STAG_HPAGESIZE_M \
	((u64)3 << IRDMA_CQPSQ_STAG_HPAGESIZE_S)

#define IRDMA_CQPSQ_STAG_ARIGHTS_S 48
#define IRDMA_CQPSQ_STAG_ARIGHTS_M \
	(0x1fULL << IRDMA_CQPSQ_STAG_ARIGHTS_S)

#define IRDMA_CQPSQ_STAG_REMACCENABLED_S 53
#define IRDMA_CQPSQ_STAG_REMACCENABLED_M \
	BIT_ULL(IRDMA_CQPSQ_STAG_REMACCENABLED_S)

#define IRDMA_CQPSQ_STAG_VABASEDTO_S 59
#define IRDMA_CQPSQ_STAG_VABASEDTO_M \
	BIT_ULL(IRDMA_CQPSQ_STAG_VABASEDTO_S)

#define IRDMA_CQPSQ_STAG_USEHMCFNIDX_S 60
#define IRDMA_CQPSQ_STAG_USEHMCFNIDX_M \
	BIT_ULL(IRDMA_CQPSQ_STAG_USEHMCFNIDX_S)

#define IRDMA_CQPSQ_STAG_USEPFRID_S 61
#define IRDMA_CQPSQ_STAG_USEPFRID_M \
	BIT_ULL(IRDMA_CQPSQ_STAG_USEPFRID_S)

#define IRDMA_CQPSQ_STAG_PBA_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQPSQ_STAG_PBA_M IRDMA_CQPHC_QPCTX_M

#define IRDMA_CQPSQ_STAG_HMCFNIDX_S 0
#define IRDMA_CQPSQ_STAG_HMCFNIDX_M \
	(0x3fULL << IRDMA_CQPSQ_STAG_HMCFNIDX_S)

#define IRDMA_CQPSQ_STAG_FIRSTPMPBLIDX_S 0
#define IRDMA_CQPSQ_STAG_FIRSTPMPBLIDX_M \
	(0xfffffffULL << IRDMA_CQPSQ_STAG_FIRSTPMPBLIDX_S)

#define IRDMA_CQPSQ_QUERYSTAG_IDX_S IRDMA_CQPSQ_STAG_IDX_S
#define IRDMA_CQPSQ_QUERYSTAG_IDX_M IRDMA_CQPSQ_STAG_IDX_M

/* Manage Local MAC Table - MLM */
#define IRDMA_CQPSQ_MLM_TABLEIDX_S 0
#define IRDMA_CQPSQ_MLM_TABLEIDX_M \
	(0x3fULL << IRDMA_CQPSQ_MLM_TABLEIDX_S)

#define IRDMA_CQPSQ_MLM_FREEENTRY_S 62
#define IRDMA_CQPSQ_MLM_FREEENTRY_M \
	BIT_ULL(IRDMA_CQPSQ_MLM_FREEENTRY_S)

#define IRDMA_CQPSQ_MLM_IGNORE_REF_CNT_S 61
#define IRDMA_CQPSQ_MLM_IGNORE_REF_CNT_M \
	BIT_ULL(IRDMA_CQPSQ_MLM_IGNORE_REF_CNT_S)

#define IRDMA_CQPSQ_MLM_MAC0_S 0
#define IRDMA_CQPSQ_MLM_MAC0_M (0xffULL << IRDMA_CQPSQ_MLM_MAC0_S)

#define IRDMA_CQPSQ_MLM_MAC1_S 8
#define IRDMA_CQPSQ_MLM_MAC1_M (0xffULL << IRDMA_CQPSQ_MLM_MAC1_S)

#define IRDMA_CQPSQ_MLM_MAC2_S 16
#define IRDMA_CQPSQ_MLM_MAC2_M (0xffULL << IRDMA_CQPSQ_MLM_MAC2_S)

#define IRDMA_CQPSQ_MLM_MAC3_S 24
#define IRDMA_CQPSQ_MLM_MAC3_M (0xffULL << IRDMA_CQPSQ_MLM_MAC3_S)

#define IRDMA_CQPSQ_MLM_MAC4_S 32
#define IRDMA_CQPSQ_MLM_MAC4_M (0xffULL << IRDMA_CQPSQ_MLM_MAC4_S)

#define IRDMA_CQPSQ_MLM_MAC5_S 40
#define IRDMA_CQPSQ_MLM_MAC5_M (0xffULL << IRDMA_CQPSQ_MLM_MAC5_S)

/* Manage ARP Table  - MAT */
#define IRDMA_CQPSQ_MAT_REACHMAX_S 0
#define IRDMA_CQPSQ_MAT_REACHMAX_M \
	(0xffffffffULL << IRDMA_CQPSQ_MAT_REACHMAX_S)

#define IRDMA_CQPSQ_MAT_MACADDR_S 0
#define IRDMA_CQPSQ_MAT_MACADDR_M \
	(0xffffffffffffULL << IRDMA_CQPSQ_MAT_MACADDR_S)

#define IRDMA_CQPSQ_MAT_ARPENTRYIDX_S 0
#define IRDMA_CQPSQ_MAT_ARPENTRYIDX_M \
	(0xfffULL << IRDMA_CQPSQ_MAT_ARPENTRYIDX_S)

#define IRDMA_CQPSQ_MAT_ENTRYVALID_S 42
#define IRDMA_CQPSQ_MAT_ENTRYVALID_M \
	BIT_ULL(IRDMA_CQPSQ_MAT_ENTRYVALID_S)

#define IRDMA_CQPSQ_MAT_PERMANENT_S 43
#define IRDMA_CQPSQ_MAT_PERMANENT_M \
	BIT_ULL(IRDMA_CQPSQ_MAT_PERMANENT_S)

#define IRDMA_CQPSQ_MAT_QUERY_S 44
#define IRDMA_CQPSQ_MAT_QUERY_M BIT_ULL(IRDMA_CQPSQ_MAT_QUERY_S)

/* Manage VF PBLE Backing Pages - MVPBP*/
#define IRDMA_CQPSQ_MVPBP_PD_ENTRY_CNT_S 0
#define IRDMA_CQPSQ_MVPBP_PD_ENTRY_CNT_M \
	(0x3ffULL << IRDMA_CQPSQ_MVPBP_PD_ENTRY_CNT_S)

#define IRDMA_CQPSQ_MVPBP_FIRST_PD_INX_S 16
#define IRDMA_CQPSQ_MVPBP_FIRST_PD_INX_M \
	(0x1ffULL << IRDMA_CQPSQ_MVPBP_FIRST_PD_INX_S)

#define IRDMA_CQPSQ_MVPBP_SD_INX_S 32
#define IRDMA_CQPSQ_MVPBP_SD_INX_M \
	(0xfffULL << IRDMA_CQPSQ_MVPBP_SD_INX_S)

#define IRDMA_CQPSQ_MVPBP_INV_PD_ENT_S 62
#define IRDMA_CQPSQ_MVPBP_INV_PD_ENT_M \
	BIT_ULL(IRDMA_CQPSQ_MVPBP_INV_PD_ENT_S)

#define IRDMA_CQPSQ_MVPBP_PD_PLPBA_S 3
#define IRDMA_CQPSQ_MVPBP_PD_PLPBA_M \
	(0x1fffffffffffffffULL << IRDMA_CQPSQ_MVPBP_PD_PLPBA_S)

/* Manage Push Page - MPP */
#define IRDMA_INVALID_PUSH_PAGE_INDEX_GEN_1 0xffff
#define IRDMA_INVALID_PUSH_PAGE_INDEX 0xffffffff

#define IRDMA_CQPSQ_MPP_QS_HANDLE_S 0
#define IRDMA_CQPSQ_MPP_QS_HANDLE_M \
	(0x3ffULL << IRDMA_CQPSQ_MPP_QS_HANDLE_S)

#define IRDMA_CQPSQ_MPP_PPIDX_S 0
#define IRDMA_CQPSQ_MPP_PPIDX_M (0x3ffULL << IRDMA_CQPSQ_MPP_PPIDX_S)

#define IRDMA_CQPSQ_MPP_PPTYPE_S 60
#define IRDMA_CQPSQ_MPP_PPTYPE_M (0x3ULL << IRDMA_CQPSQ_MPP_PPTYPE_S)

#define IRDMA_CQPSQ_MPP_FREE_PAGE_S 62
#define IRDMA_CQPSQ_MPP_FREE_PAGE_M BIT_ULL(IRDMA_CQPSQ_MPP_FREE_PAGE_S)

/* Upload Context - UCTX */
#define IRDMA_CQPSQ_UCTX_QPCTXADDR_S IRDMA_CQPHC_QPCTX_S
#define IRDMA_CQPSQ_UCTX_QPCTXADDR_M IRDMA_CQPHC_QPCTX_M

#define IRDMA_CQPSQ_UCTX_QPID_S 0
#define IRDMA_CQPSQ_UCTX_QPID_M (0xffffffULL << IRDMA_CQPSQ_UCTX_QPID_S)

#define IRDMA_CQPSQ_UCTX_QPTYPE_S 48
#define IRDMA_CQPSQ_UCTX_QPTYPE_M (0xfULL << IRDMA_CQPSQ_UCTX_QPTYPE_S)

#define IRDMA_CQPSQ_UCTX_RAWFORMAT_S 61
#define IRDMA_CQPSQ_UCTX_RAWFORMAT_M \
	BIT_ULL(IRDMA_CQPSQ_UCTX_RAWFORMAT_S)

#define IRDMA_CQPSQ_UCTX_FREEZEQP_S 62
#define IRDMA_CQPSQ_UCTX_FREEZEQP_M \
	BIT_ULL(IRDMA_CQPSQ_UCTX_FREEZEQP_S)

/* Manage HMC PM Function Table - MHMC */
#define IRDMA_CQPSQ_MHMC_VFIDX_S 0
#define IRDMA_CQPSQ_MHMC_VFIDX_M (0xffffULL << IRDMA_CQPSQ_MHMC_VFIDX_S)

#define IRDMA_CQPSQ_MHMC_FREEPMFN_S 62
#define IRDMA_CQPSQ_MHMC_FREEPMFN_M \
	BIT_ULL(IRDMA_CQPSQ_MHMC_FREEPMFN_S)

/* Set HMC Resource Profile - SHMCRP */
#define IRDMA_CQPSQ_SHMCRP_HMC_PROFILE_S 0
#define IRDMA_CQPSQ_SHMCRP_HMC_PROFILE_M \
	(0x7ULL << IRDMA_CQPSQ_SHMCRP_HMC_PROFILE_S)
#define IRDMA_CQPSQ_SHMCRP_VFNUM_S 32
#define IRDMA_CQPSQ_SHMCRP_VFNUM_M (0x3fULL << IRDMA_CQPSQ_SHMCRP_VFNUM_S)

/* Create/Destroy CEQ */
#define IRDMA_CQPSQ_CEQ_CEQSIZE_S 0
#define IRDMA_CQPSQ_CEQ_CEQSIZE_M \
	(0x3fffffULL << IRDMA_CQPSQ_CEQ_CEQSIZE_S)

#define IRDMA_CQPSQ_CEQ_CEQID_S 0
#define IRDMA_CQPSQ_CEQ_CEQID_M (0x3ffULL << IRDMA_CQPSQ_CEQ_CEQID_S)

#define IRDMA_CQPSQ_CEQ_LPBLSIZE_S IRDMA_CQPSQ_CQ_LPBLSIZE_S
#define IRDMA_CQPSQ_CEQ_LPBLSIZE_M IRDMA_CQPSQ_CQ_LPBLSIZE_M

#define IRDMA_CQPSQ_CEQ_VMAP_S 47
#define IRDMA_CQPSQ_CEQ_VMAP_M BIT_ULL(IRDMA_CQPSQ_CEQ_VMAP_S)

#define IRDMA_CQPSQ_CEQ_ITRNOEXPIRE_S 46
#define IRDMA_CQPSQ_CEQ_ITRNOEXPIRE_M BIT_ULL(IRDMA_CQPSQ_CEQ_ITRNOEXPIRE_S)

#define IRDMA_CQPSQ_CEQ_FIRSTPMPBLIDX_S 0
#define IRDMA_CQPSQ_CEQ_FIRSTPMPBLIDX_M \
	(0xfffffffULL << IRDMA_CQPSQ_CEQ_FIRSTPMPBLIDX_S)

/* Create/Destroy AEQ */
#define IRDMA_CQPSQ_AEQ_AEQECNT_S 0
#define IRDMA_CQPSQ_AEQ_AEQECNT_M \
	(0x7ffffULL << IRDMA_CQPSQ_AEQ_AEQECNT_S)

#define IRDMA_CQPSQ_AEQ_LPBLSIZE_S IRDMA_CQPSQ_CQ_LPBLSIZE_S
#define IRDMA_CQPSQ_AEQ_LPBLSIZE_M IRDMA_CQPSQ_CQ_LPBLSIZE_M

#define IRDMA_CQPSQ_AEQ_VMAP_S 47
#define IRDMA_CQPSQ_AEQ_VMAP_M BIT_ULL(IRDMA_CQPSQ_AEQ_VMAP_S)

#define IRDMA_CQPSQ_AEQ_FIRSTPMPBLIDX_S 0
#define IRDMA_CQPSQ_AEQ_FIRSTPMPBLIDX_M \
	(0xfffffffULL << IRDMA_CQPSQ_AEQ_FIRSTPMPBLIDX_S)

/* Commit FPM Values - CFPM */
#define IRDMA_COMMIT_FPM_QPCNT_S 0
#define IRDMA_COMMIT_FPM_QPCNT_M (0x7ffffULL << IRDMA_COMMIT_FPM_QPCNT_S)

#define IRDMA_COMMIT_FPM_BASE_S 32

#define IRDMA_CQPSQ_CFPM_HMCFNID_S 0
#define IRDMA_CQPSQ_CFPM_HMCFNID_M (0x3fULL << IRDMA_CQPSQ_CFPM_HMCFNID_S)

/* Flush WQEs - FWQE */
#define IRDMA_CQPSQ_FWQE_AECODE_S 0
#define IRDMA_CQPSQ_FWQE_AECODE_M (0xffffULL << IRDMA_CQPSQ_FWQE_AECODE_S)

#define IRDMA_CQPSQ_FWQE_AESOURCE_S 16
#define IRDMA_CQPSQ_FWQE_AESOURCE_M \
	(0xfULL << IRDMA_CQPSQ_FWQE_AESOURCE_S)

#define IRDMA_CQPSQ_FWQE_RQMNERR_S 0
#define IRDMA_CQPSQ_FWQE_RQMNERR_M \
	(0xffffULL << IRDMA_CQPSQ_FWQE_RQMNERR_S)

#define IRDMA_CQPSQ_FWQE_RQMJERR_S 16
#define IRDMA_CQPSQ_FWQE_RQMJERR_M \
	(0xffffULL << IRDMA_CQPSQ_FWQE_RQMJERR_S)

#define IRDMA_CQPSQ_FWQE_SQMNERR_S 32
#define IRDMA_CQPSQ_FWQE_SQMNERR_M \
	(0xffffULL << IRDMA_CQPSQ_FWQE_SQMNERR_S)

#define IRDMA_CQPSQ_FWQE_SQMJERR_S 48
#define IRDMA_CQPSQ_FWQE_SQMJERR_M \
	(0xffffULL << IRDMA_CQPSQ_FWQE_SQMJERR_S)

#define IRDMA_CQPSQ_FWQE_QPID_S 0
#define IRDMA_CQPSQ_FWQE_QPID_M (0xffffffULL << IRDMA_CQPSQ_FWQE_QPID_S)

#define IRDMA_CQPSQ_FWQE_GENERATE_AE_S 59
#define IRDMA_CQPSQ_FWQE_GENERATE_AE_M \
	BIT_ULL(IRDMA_CQPSQ_FWQE_GENERATE_AE_S)

#define IRDMA_CQPSQ_FWQE_USERFLCODE_S 60
#define IRDMA_CQPSQ_FWQE_USERFLCODE_M \
	BIT_ULL(IRDMA_CQPSQ_FWQE_USERFLCODE_S)

#define IRDMA_CQPSQ_FWQE_FLUSHSQ_S 61
#define IRDMA_CQPSQ_FWQE_FLUSHSQ_M BIT_ULL(IRDMA_CQPSQ_FWQE_FLUSHSQ_S)

#define IRDMA_CQPSQ_FWQE_FLUSHRQ_S 62
#define IRDMA_CQPSQ_FWQE_FLUSHRQ_M BIT_ULL(IRDMA_CQPSQ_FWQE_FLUSHRQ_S)

/* Manage Accelerated Port Table - MAPT */
#define IRDMA_CQPSQ_MAPT_PORT_S 0
#define IRDMA_CQPSQ_MAPT_PORT_M (0xffffULL << IRDMA_CQPSQ_MAPT_PORT_S)

#define IRDMA_CQPSQ_MAPT_ADDPORT_S 62
#define IRDMA_CQPSQ_MAPT_ADDPORT_M BIT_ULL(IRDMA_CQPSQ_MAPT_ADDPORT_S)

/* Update Protocol Engine SDs */
#define IRDMA_CQPSQ_UPESD_SDCMD_S 0
#define IRDMA_CQPSQ_UPESD_SDCMD_M (0xffffffffULL << IRDMA_CQPSQ_UPESD_SDCMD_S)

#define IRDMA_CQPSQ_UPESD_SDDATALOW_S 0
#define IRDMA_CQPSQ_UPESD_SDDATALOW_M \
	(0xffffffffULL << IRDMA_CQPSQ_UPESD_SDDATALOW_S)

#define IRDMA_CQPSQ_UPESD_SDDATAHI_S 32
#define IRDMA_CQPSQ_UPESD_SDDATAHI_M \
	(0xffffffffULL << IRDMA_CQPSQ_UPESD_SDDATAHI_S)
#define IRDMA_CQPSQ_UPESD_HMCFNID_S 0
#define IRDMA_CQPSQ_UPESD_HMCFNID_M \
	(0x3fULL << IRDMA_CQPSQ_UPESD_HMCFNID_S)

#define IRDMA_CQPSQ_UPESD_ENTRY_VALID_S 63
#define IRDMA_CQPSQ_UPESD_ENTRY_VALID_M \
	BIT_ULL(IRDMA_CQPSQ_UPESD_ENTRY_VALID_S)

#define IRDMA_CQPSQ_UPESD_ENTRY_COUNT_S 0
#define IRDMA_CQPSQ_UPESD_ENTRY_COUNT_M \
	(0xfULL << IRDMA_CQPSQ_UPESD_ENTRY_COUNT_S)

#define IRDMA_CQPSQ_UPESD_SKIP_ENTRY_S 7
#define IRDMA_CQPSQ_UPESD_SKIP_ENTRY_M \
	BIT_ULL(IRDMA_CQPSQ_UPESD_SKIP_ENTRY_S)

/* Suspend QP */
#define IRDMA_CQPSQ_SUSPENDQP_QPID_S 0
#define IRDMA_CQPSQ_SUSPENDQP_QPID_M (0xFFFFFFULL)

/* Resume QP */
#define IRDMA_CQPSQ_RESUMEQP_QSHANDLE_S 0
#define IRDMA_CQPSQ_RESUMEQP_QSHANDLE_M \
	(0xffffffffULL << IRDMA_CQPSQ_RESUMEQP_QSHANDLE_S)

#define IRDMA_CQPSQ_RESUMEQP_QPID_S 0
#define IRDMA_CQPSQ_RESUMEQP_QPID_M (0xFFFFFFUL)

#define IRDMA_CQPSQ_MIN_STAG_INVALID 0x0001
#define IRDMA_CQPSQ_MIN_SUSPEND_PND 0x0005

#define IRDMA_CQPSQ_MAJ_NO_ERROR 0x0000
#define IRDMA_CQPSQ_MAJ_OBJCACHE_ERROR 0xF000
#define IRDMA_CQPSQ_MAJ_CNTXTCACHE_ERROR 0xF001
#define IRDMA_CQPSQ_MAJ_ERROR 0xFFFF

/* IW QP Context */
#define IRDMAQPC_DDP_VER_S 0
#define IRDMAQPC_DDP_VER_M (3ULL << IRDMAQPC_DDP_VER_S)

#define IRDMAQPC_IBRDENABLE_S 2
#define IRDMAQPC_IBRDENABLE_M BIT_ULL(IRDMAQPC_IBRDENABLE_S)

#define IRDMAQPC_IPV4_S 3
#define IRDMAQPC_IPV4_M BIT_ULL(IRDMAQPC_IPV4_S)

#define IRDMAQPC_NONAGLE_S 4
#define IRDMAQPC_NONAGLE_M BIT_ULL(IRDMAQPC_NONAGLE_S)

#define IRDMAQPC_INSERTVLANTAG_S 5
#define IRDMAQPC_INSERTVLANTAG_M BIT_ULL(IRDMAQPC_INSERTVLANTAG_S)

#define IRDMAQPC_ISQP1_S 6
#define IRDMAQPC_ISQP1_M BIT_ULL(IRDMAQPC_ISQP1_S)

#define IRDMAQPC_TIMESTAMP_S 7
#define IRDMAQPC_TIMESTAMP_M BIT_ULL(IRDMAQPC_TIMESTAMP_S)

#define IRDMAQPC_RQWQESIZE_S 8
#define IRDMAQPC_RQWQESIZE_M (3ULL << IRDMAQPC_RQWQESIZE_S)

#define IRDMAQPC_INSERTL2TAG2_S 11
#define IRDMAQPC_INSERTL2TAG2_M BIT_ULL(IRDMAQPC_INSERTL2TAG2_S)

#define IRDMAQPC_LIMIT_S 12
#define IRDMAQPC_LIMIT_M (3ULL << IRDMAQPC_LIMIT_S)

#define IRDMAQPC_ECN_EN_S 14
#define IRDMAQPC_ECN_EN_M BIT_ULL(IRDMAQPC_ECN_EN_S)

#define IRDMAQPC_DROPOOOSEG_S 15
#define IRDMAQPC_DROPOOOSEG_M BIT_ULL(IRDMAQPC_DROPOOOSEG_S)

#define IRDMAQPC_DUPACK_THRESH_S 16
#define IRDMAQPC_DUPACK_THRESH_M (7ULL << IRDMAQPC_DUPACK_THRESH_S)

#define IRDMAQPC_ERR_RQ_IDX_VALID_S 19
#define IRDMAQPC_ERR_RQ_IDX_VALID_M BIT_ULL(IRDMAQPC_ERR_RQ_IDX_VALID_S)

#define IRDMAQPC_DIS_VLAN_CHECKS_S 19
#define IRDMAQPC_DIS_VLAN_CHECKS_M (7ULL << IRDMAQPC_DIS_VLAN_CHECKS_S)

#define IRDMAQPC_DC_TCP_EN_S 25
#define IRDMAQPC_DC_TCP_EN_M BIT_ULL(IRDMAQPC_DC_TCP_EN_S)

#define IRDMAQPC_RCVTPHEN_S 28
#define IRDMAQPC_RCVTPHEN_M BIT_ULL(IRDMAQPC_RCVTPHEN_S)

#define IRDMAQPC_XMITTPHEN_S 29
#define IRDMAQPC_XMITTPHEN_M BIT_ULL(IRDMAQPC_XMITTPHEN_S)

#define IRDMAQPC_RQTPHEN_S 30
#define IRDMAQPC_RQTPHEN_M BIT_ULL(IRDMAQPC_RQTPHEN_S)

#define IRDMAQPC_SQTPHEN_S 31
#define IRDMAQPC_SQTPHEN_M BIT_ULL(IRDMAQPC_SQTPHEN_S)

#define IRDMAQPC_PPIDX_S 32
#define IRDMAQPC_PPIDX_M (0x3ffULL << IRDMAQPC_PPIDX_S)

#define IRDMAQPC_PMENA_S 47
#define IRDMAQPC_PMENA_M BIT_ULL(IRDMAQPC_PMENA_S)

#define IRDMAQPC_RDMAP_VER_S 62
#define IRDMAQPC_RDMAP_VER_M (3ULL << IRDMAQPC_RDMAP_VER_S)

#define IRDMAQPC_ROCE_TVER_S 60
#define IRDMAQPC_ROCE_TVER_M (0x0fULL << IRDMAQPC_ROCE_TVER_S)
#define IRDMAQPC_SQADDR_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPC_SQADDR_M IRDMA_CQPHC_QPCTX_M

#define IRDMAQPC_RQADDR_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPC_RQADDR_M IRDMA_CQPHC_QPCTX_M

#define IRDMAQPC_TTL_S 0
#define IRDMAQPC_TTL_M (0xffULL << IRDMAQPC_TTL_S)

#define IRDMAQPC_RQSIZE_S 8
#define IRDMAQPC_RQSIZE_M (0xfULL << IRDMAQPC_RQSIZE_S)

#define IRDMAQPC_SQSIZE_S 12
#define IRDMAQPC_SQSIZE_M (0xfULL << IRDMAQPC_SQSIZE_S)

#define IRDMAQPC_GEN1_SRCMACADDRIDX_S 16
#define IRDMAQPC_GEN1_SRCMACADDRIDX_M (0x3fUL << IRDMAQPC_GEN1_SRCMACADDRIDX_S)

#define IRDMAQPC_AVOIDSTRETCHACK_S 23
#define IRDMAQPC_AVOIDSTRETCHACK_M BIT_ULL(IRDMAQPC_AVOIDSTRETCHACK_S)

#define IRDMAQPC_TOS_S 24
#define IRDMAQPC_TOS_M (0xffULL << IRDMAQPC_TOS_S)

#define IRDMAQPC_SRCPORTNUM_S 32
#define IRDMAQPC_SRCPORTNUM_M (0xffffULL << IRDMAQPC_SRCPORTNUM_S)

#define IRDMAQPC_DESTPORTNUM_S 48
#define IRDMAQPC_DESTPORTNUM_M (0xffffULL << IRDMAQPC_DESTPORTNUM_S)

#define IRDMAQPC_DESTIPADDR0_S 32
#define IRDMAQPC_DESTIPADDR0_M \
	(0xffffffffULL << IRDMAQPC_DESTIPADDR0_S)

#define IRDMAQPC_DESTIPADDR1_S 0
#define IRDMAQPC_DESTIPADDR1_M \
	(0xffffffffULL << IRDMAQPC_DESTIPADDR1_S)

#define IRDMAQPC_DESTIPADDR2_S 32
#define IRDMAQPC_DESTIPADDR2_M \
	(0xffffffffULL << IRDMAQPC_DESTIPADDR2_S)

#define IRDMAQPC_DESTIPADDR3_S 0
#define IRDMAQPC_DESTIPADDR3_M \
	(0xffffffffULL << IRDMAQPC_DESTIPADDR3_S)

#define IRDMAQPC_SNDMSS_S 16
#define IRDMAQPC_SNDMSS_M (0x3fffULL << IRDMAQPC_SNDMSS_S)

#define IRDMAQPC_SYN_RST_HANDLING_S 30
#define IRDMAQPC_SYN_RST_HANDLING_M (0x3ULL << IRDMAQPC_SYN_RST_HANDLING_S)

#define IRDMAQPC_VLANTAG_S 32
#define IRDMAQPC_VLANTAG_M (0xffffULL << IRDMAQPC_VLANTAG_S)

#define IRDMAQPC_ARPIDX_S 48
#define IRDMAQPC_ARPIDX_M (0xffffULL << IRDMAQPC_ARPIDX_S)

#define IRDMAQPC_FLOWLABEL_S 0
#define IRDMAQPC_FLOWLABEL_M (0xfffffULL << IRDMAQPC_FLOWLABEL_S)

#define IRDMAQPC_WSCALE_S 20
#define IRDMAQPC_WSCALE_M BIT_ULL(IRDMAQPC_WSCALE_S)

#define IRDMAQPC_KEEPALIVE_S 21
#define IRDMAQPC_KEEPALIVE_M BIT_ULL(IRDMAQPC_KEEPALIVE_S)

#define IRDMAQPC_IGNORE_TCP_OPT_S 22
#define IRDMAQPC_IGNORE_TCP_OPT_M BIT_ULL(IRDMAQPC_IGNORE_TCP_OPT_S)

#define IRDMAQPC_IGNORE_TCP_UNS_OPT_S 23
#define IRDMAQPC_IGNORE_TCP_UNS_OPT_M \
	BIT_ULL(IRDMAQPC_IGNORE_TCP_UNS_OPT_S)

#define IRDMAQPC_TCPSTATE_S 28
#define IRDMAQPC_TCPSTATE_M (0xfULL << IRDMAQPC_TCPSTATE_S)

#define IRDMAQPC_RCVSCALE_S 32
#define IRDMAQPC_RCVSCALE_M (0xfULL << IRDMAQPC_RCVSCALE_S)

#define IRDMAQPC_SNDSCALE_S 40
#define IRDMAQPC_SNDSCALE_M (0xfULL << IRDMAQPC_SNDSCALE_S)

#define IRDMAQPC_PDIDX_S 48
#define IRDMAQPC_PDIDX_M (0xffffULL << IRDMAQPC_PDIDX_S)

#define IRDMAQPC_PDIDXHI_S 20
#define IRDMAQPC_PDIDXHI_M (0x3ULL << IRDMAQPC_PDIDXHI_S)

#define IRDMAQPC_PKEY_S 32
#define IRDMAQPC_PKEY_M (0xffffULL << IRDMAQPC_PKEY_S)

#define IRDMAQPC_ACKCREDITS_S 20
#define IRDMAQPC_ACKCREDITS_M (0x1fULL << IRDMAQPC_ACKCREDITS_S)

#define IRDMAQPC_QKEY_S 32
#define IRDMAQPC_QKEY_M (0xffffffffULL << IRDMAQPC_QKEY_S)

#define IRDMAQPC_DESTQP_S 0
#define IRDMAQPC_DESTQP_M (0xffffffULL << IRDMAQPC_DESTQP_S)

#define IRDMAQPC_KALIVE_TIMER_MAX_PROBES_S 16
#define IRDMAQPC_KALIVE_TIMER_MAX_PROBES_M \
	(0xffULL << IRDMAQPC_KALIVE_TIMER_MAX_PROBES_S)

#define IRDMAQPC_KEEPALIVE_INTERVAL_S 24
#define IRDMAQPC_KEEPALIVE_INTERVAL_M \
	(0xffULL << IRDMAQPC_KEEPALIVE_INTERVAL_S)

#define IRDMAQPC_TIMESTAMP_RECENT_S 0
#define IRDMAQPC_TIMESTAMP_RECENT_M \
	(0xffffffffULL << IRDMAQPC_TIMESTAMP_RECENT_S)

#define IRDMAQPC_TIMESTAMP_AGE_S 32
#define IRDMAQPC_TIMESTAMP_AGE_M \
	(0xffffffffULL << IRDMAQPC_TIMESTAMP_AGE_S)

#define IRDMAQPC_SNDNXT_S 0
#define IRDMAQPC_SNDNXT_M (0xffffffffULL << IRDMAQPC_SNDNXT_S)

#define IRDMAQPC_ISN_S 32
#define IRDMAQPC_ISN_M (0x00ffffffULL << IRDMAQPC_ISN_S)

#define IRDMAQPC_PSNNXT_S 0
#define IRDMAQPC_PSNNXT_M (0x00ffffffULL << IRDMAQPC_PSNNXT_S)

#define IRDMAQPC_LSN_S 32
#define IRDMAQPC_LSN_M (0x00ffffffULL << IRDMAQPC_LSN_S)

#define IRDMAQPC_SNDWND_S 32
#define IRDMAQPC_SNDWND_M (0xffffffffULL << IRDMAQPC_SNDWND_S)

#define IRDMAQPC_RCVNXT_S 0
#define IRDMAQPC_RCVNXT_M (0xffffffffULL << IRDMAQPC_RCVNXT_S)

#define IRDMAQPC_EPSN_S 0
#define IRDMAQPC_EPSN_M (0x00ffffffULL << IRDMAQPC_EPSN_S)

#define IRDMAQPC_RCVWND_S 32
#define IRDMAQPC_RCVWND_M (0xffffffffULL << IRDMAQPC_RCVWND_S)

#define IRDMAQPC_SNDMAX_S 0
#define IRDMAQPC_SNDMAX_M (0xffffffffULL << IRDMAQPC_SNDMAX_S)

#define IRDMAQPC_SNDUNA_S 32
#define IRDMAQPC_SNDUNA_M (0xffffffffULL << IRDMAQPC_SNDUNA_S)

#define IRDMAQPC_PSNMAX_S 0
#define IRDMAQPC_PSNMAX_M (0x00ffffffULL << IRDMAQPC_PSNMAX_S)
#define IRDMAQPC_PSNUNA_S 32
#define IRDMAQPC_PSNUNA_M (0xffffffULL << IRDMAQPC_PSNUNA_S)

#define IRDMAQPC_SRTT_S 0
#define IRDMAQPC_SRTT_M (0xffffffffULL << IRDMAQPC_SRTT_S)

#define IRDMAQPC_RTTVAR_S 32
#define IRDMAQPC_RTTVAR_M (0xffffffffULL << IRDMAQPC_RTTVAR_S)

#define IRDMAQPC_SSTHRESH_S 0
#define IRDMAQPC_SSTHRESH_M (0xffffffffULL << IRDMAQPC_SSTHRESH_S)

#define IRDMAQPC_CWND_S 32
#define IRDMAQPC_CWND_M (0xffffffffULL << IRDMAQPC_CWND_S)

#define IRDMAQPC_CWNDROCE_S 32
#define IRDMAQPC_CWNDROCE_M (0xffffffULL << IRDMAQPC_CWNDROCE_S)
#define IRDMAQPC_SNDWL1_S 0
#define IRDMAQPC_SNDWL1_M (0xffffffffULL << IRDMAQPC_SNDWL1_S)

#define IRDMAQPC_SNDWL2_S 32
#define IRDMAQPC_SNDWL2_M (0xffffffffULL << IRDMAQPC_SNDWL2_S)

#define IRDMAQPC_ERR_RQ_IDX_S 32
#define IRDMAQPC_ERR_RQ_IDX_M (0x3fffULL << IRDMAQPC_ERR_RQ_IDX_S)

#define IRDMAQPC_RTOMIN_S 57
#define IRDMAQPC_RTOMIN_M (0x7fULL << IRDMAQPC_RTOMIN_S)

#define IRDMAQPC_MAXSNDWND_S 0
#define IRDMAQPC_MAXSNDWND_M (0xffffffffULL << IRDMAQPC_MAXSNDWND_S)

#define IRDMAQPC_REXMIT_THRESH_S 48
#define IRDMAQPC_REXMIT_THRESH_M (0x3fULL << IRDMAQPC_REXMIT_THRESH_S)

#define IRDMAQPC_RNRNAK_THRESH_S 54
#define IRDMAQPC_RNRNAK_THRESH_M (0x7ULL << IRDMAQPC_RNRNAK_THRESH_S)

#define IRDMAQPC_TXCQNUM_S 0
#define IRDMAQPC_TXCQNUM_M (0x7ffffULL << IRDMAQPC_TXCQNUM_S)

#define IRDMAQPC_RXCQNUM_S 32
#define IRDMAQPC_RXCQNUM_M (0x7ffffULL << IRDMAQPC_RXCQNUM_S)

#define IRDMAQPC_STAT_INDEX_S 0
#define IRDMAQPC_STAT_INDEX_M (0x7fULL << IRDMAQPC_STAT_INDEX_S)

#define IRDMAQPC_Q2ADDR_S 8
#define IRDMAQPC_Q2ADDR_M (0xffffffffffffffULL << IRDMAQPC_Q2ADDR_S)

#define IRDMAQPC_LASTBYTESENT_S 0
#define IRDMAQPC_LASTBYTESENT_M (0xffULL << IRDMAQPC_LASTBYTESENT_S)

#define IRDMAQPC_MACADDRESS_S 16
#define IRDMAQPC_MACADDRESS_M (0xffffffffffffULL << IRDMAQPC_MACADDRESS_S)

#define IRDMAQPC_ORDSIZE_S 0
#define IRDMAQPC_ORDSIZE_M (0xffULL << IRDMAQPC_ORDSIZE_S)

#define IRDMAQPC_IRDSIZE_S 16
#define IRDMAQPC_IRDSIZE_M (0x7ULL << IRDMAQPC_IRDSIZE_S)

#define IRDMAQPC_UDPRIVCQENABLE_S 19
#define IRDMAQPC_UDPRIVCQENABLE_M BIT_ULL(IRDMAQPC_UDPRIVCQENABLE_S)

#define IRDMAQPC_WRRDRSPOK_S 20
#define IRDMAQPC_WRRDRSPOK_M BIT_ULL(IRDMAQPC_WRRDRSPOK_S)

#define IRDMAQPC_RDOK_S 21
#define IRDMAQPC_RDOK_M BIT_ULL(IRDMAQPC_RDOK_S)

#define IRDMAQPC_SNDMARKERS_S 22
#define IRDMAQPC_SNDMARKERS_M BIT_ULL(IRDMAQPC_SNDMARKERS_S)

#define IRDMAQPC_DCQCNENABLE_S 22
#define IRDMAQPC_DCQCNENABLE_M BIT_ULL(IRDMAQPC_DCQCNENABLE_S)

#define IRDMAQPC_FW_CC_ENABLE_S 28
#define IRDMAQPC_FW_CC_ENABLE_M BIT_ULL(IRDMAQPC_FW_CC_ENABLE_S)

#define IRDMAQPC_RCVNOICRC_S 31
#define IRDMAQPC_RCVNOICRC_M BIT_ULL(IRDMAQPC_RCVNOICRC_S)

#define IRDMAQPC_BINDEN_S 23
#define IRDMAQPC_BINDEN_M BIT_ULL(IRDMAQPC_BINDEN_S)

#define IRDMAQPC_FASTREGEN_S 24
#define IRDMAQPC_FASTREGEN_M BIT_ULL(IRDMAQPC_FASTREGEN_S)

#define IRDMAQPC_PRIVEN_S 25
#define IRDMAQPC_PRIVEN_M BIT_ULL(IRDMAQPC_PRIVEN_S)

#define IRDMAQPC_TIMELYENABLE_S 27
#define IRDMAQPC_TIMELYENABLE_M BIT_ULL(IRDMAQPC_TIMELYENABLE_S)

#define IRDMAQPC_THIGH_S 52
#define IRDMAQPC_THIGH_M ((u64)0xfff << IRDMAQPC_THIGH_S)

#define IRDMAQPC_TLOW_S 32
#define IRDMAQPC_TLOW_M ((u64)0xFF << IRDMAQPC_TLOW_S)

#define IRDMAQPC_REMENDPOINTIDX_S 0
#define IRDMAQPC_REMENDPOINTIDX_M ((u64)0x1FFFF << IRDMAQPC_REMENDPOINTIDX_S)

#define IRDMAQPC_USESTATSINSTANCE_S 26
#define IRDMAQPC_USESTATSINSTANCE_M BIT_ULL(IRDMAQPC_USESTATSINSTANCE_S)

#define IRDMAQPC_IWARPMODE_S 28
#define IRDMAQPC_IWARPMODE_M BIT_ULL(IRDMAQPC_IWARPMODE_S)

#define IRDMAQPC_RCVMARKERS_S 29
#define IRDMAQPC_RCVMARKERS_M BIT_ULL(IRDMAQPC_RCVMARKERS_S)

#define IRDMAQPC_ALIGNHDRS_S 30
#define IRDMAQPC_ALIGNHDRS_M BIT_ULL(IRDMAQPC_ALIGNHDRS_S)

#define IRDMAQPC_RCVNOMPACRC_S 31
#define IRDMAQPC_RCVNOMPACRC_M BIT_ULL(IRDMAQPC_RCVNOMPACRC_S)

#define IRDMAQPC_RCVMARKOFFSET_S 32
#define IRDMAQPC_RCVMARKOFFSET_M (0x1ffULL << IRDMAQPC_RCVMARKOFFSET_S)

#define IRDMAQPC_SNDMARKOFFSET_S 48
#define IRDMAQPC_SNDMARKOFFSET_M (0x1ffULL << IRDMAQPC_SNDMARKOFFSET_S)

#define IRDMAQPC_QPCOMPCTX_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPC_QPCOMPCTX_M IRDMA_CQPHC_QPCTX_M

#define IRDMAQPC_SQTPHVAL_S 0
#define IRDMAQPC_SQTPHVAL_M (0xffULL << IRDMAQPC_SQTPHVAL_S)

#define IRDMAQPC_RQTPHVAL_S 8
#define IRDMAQPC_RQTPHVAL_M (0xffULL << IRDMAQPC_RQTPHVAL_S)

#define IRDMAQPC_QSHANDLE_S 16
#define IRDMAQPC_QSHANDLE_M (0x3ffULL << IRDMAQPC_QSHANDLE_S)

#define IRDMAQPC_EXCEPTION_LAN_QUEUE_S 32
#define IRDMAQPC_EXCEPTION_LAN_QUEUE_M \
	(0xfffULL << IRDMAQPC_EXCEPTION_LAN_QUEUE_S)

#define IRDMAQPC_LOCAL_IPADDR3_S 0
#define IRDMAQPC_LOCAL_IPADDR3_M \
	(0xffffffffULL << IRDMAQPC_LOCAL_IPADDR3_S)

#define IRDMAQPC_LOCAL_IPADDR2_S 32
#define IRDMAQPC_LOCAL_IPADDR2_M \
	(0xffffffffULL << IRDMAQPC_LOCAL_IPADDR2_S)

#define IRDMAQPC_LOCAL_IPADDR1_S 0
#define IRDMAQPC_LOCAL_IPADDR1_M \
	(0xffffffffULL << IRDMAQPC_LOCAL_IPADDR1_S)

#define IRDMAQPC_LOCAL_IPADDR0_S 32
#define IRDMAQPC_LOCAL_IPADDR0_M \
	(0xffffffffULL << IRDMAQPC_LOCAL_IPADDR0_S)

#define IRDMA_FW_VER_MINOR_S 0
#define IRDMA_FW_VER_MINOR_M \
	(0xffffULL << IRDMA_FW_VER_MINOR_S)

#define IRDMA_FW_VER_MAJOR_S 16
#define IRDMA_FW_VER_MAJOR_M \
	(0xffffULL << IRDMA_FW_VER_MAJOR_S)

#define IRDMA_FEATURE_INFO_S 0
#define IRDMA_FEATURE_INFO_M \
	(0xffffffffffffULL << IRDMA_FEATURE_INFO_S)

#define IRDMA_FEATURE_CNT_S 32
#define IRDMA_FEATURE_CNT_M \
	(0xffffULL << IRDMA_FEATURE_CNT_S)

#define IRDMA_FEATURE_TYPE_S 48
#define IRDMA_FEATURE_TYPE_M \
	(0xffffULL << IRDMA_FEATURE_TYPE_S)

#define IRDMA_RSVD_S 41
#define IRDMA_RSVD_M (0x7fffULL << IRDMA_RSVD_S)

/* iwarp QP SQ WQE common fields */
#define IRDMAQPSQ_OPCODE_S 32
#define IRDMAQPSQ_OPCODE_M (0x3fULL << IRDMAQPSQ_OPCODE_S)

#define IRDMAQPSQ_COPY_HOST_PBL_S 43
#define IRDMAQPSQ_COPY_HOST_PBL_M BIT_ULL(IRDMAQPSQ_COPY_HOST_PBL_S)

#define IRDMAQPSQ_ADDFRAGCNT_S 38
#define IRDMAQPSQ_ADDFRAGCNT_M (0xfULL << IRDMAQPSQ_ADDFRAGCNT_S)

#define IRDMAQPSQ_PUSHWQE_S 56
#define IRDMAQPSQ_PUSHWQE_M BIT_ULL(IRDMAQPSQ_PUSHWQE_S)

#define IRDMAQPSQ_STREAMMODE_S 58
#define IRDMAQPSQ_STREAMMODE_M BIT_ULL(IRDMAQPSQ_STREAMMODE_S)

#define IRDMAQPSQ_WAITFORRCVPDU_S 59
#define IRDMAQPSQ_WAITFORRCVPDU_M BIT_ULL(IRDMAQPSQ_WAITFORRCVPDU_S)

#define IRDMAQPSQ_READFENCE_S 60
#define IRDMAQPSQ_READFENCE_M BIT_ULL(IRDMAQPSQ_READFENCE_S)

#define IRDMAQPSQ_LOCALFENCE_S 61
#define IRDMAQPSQ_LOCALFENCE_M BIT_ULL(IRDMAQPSQ_LOCALFENCE_S)

#define IRDMAQPSQ_UDPHEADER_S 61
#define IRDMAQPSQ_UDPHEADER_M BIT_ULL(IRDMAQPSQ_UDPHEADER_S)

#define IRDMAQPSQ_L4LEN_S 42
#define IRDMAQPSQ_L4LEN_M ((u64)0xF << IRDMAQPSQ_L4LEN_S)

#define IRDMAQPSQ_SIGCOMPL_S 62
#define IRDMAQPSQ_SIGCOMPL_M BIT_ULL(IRDMAQPSQ_SIGCOMPL_S)

#define IRDMAQPSQ_VALID_S 63
#define IRDMAQPSQ_VALID_M BIT_ULL(IRDMAQPSQ_VALID_S)

#define IRDMAQPSQ_FRAG_TO_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPSQ_FRAG_TO_M IRDMA_CQPHC_QPCTX_M

#define IRDMAQPSQ_FRAG_VALID_S 63
#define IRDMAQPSQ_FRAG_VALID_M BIT_ULL(IRDMAQPSQ_FRAG_VALID_S)

#define IRDMAQPSQ_FRAG_LEN_S 32
#define IRDMAQPSQ_FRAG_LEN_M (0x7fffffffULL << IRDMAQPSQ_FRAG_LEN_S)

#define IRDMAQPSQ_FRAG_STAG_S 0
#define IRDMAQPSQ_FRAG_STAG_M (0xffffffffULL << IRDMAQPSQ_FRAG_STAG_S)

#define IRDMAQPSQ_GEN1_FRAG_LEN_S 0
#define IRDMAQPSQ_GEN1_FRAG_LEN_M (0xffffffffULL << IRDMAQPSQ_GEN1_FRAG_LEN_S)

#define IRDMAQPSQ_GEN1_FRAG_STAG_S 32
#define IRDMAQPSQ_GEN1_FRAG_STAG_M (0xffffffffULL << IRDMAQPSQ_GEN1_FRAG_STAG_S)

#define IRDMAQPSQ_REMSTAGINV_S 0
#define IRDMAQPSQ_REMSTAGINV_M (0xffffffffULL << IRDMAQPSQ_REMSTAGINV_S)

#define IRDMAQPSQ_DESTQKEY_S 0
#define IRDMAQPSQ_DESTQKEY_M (0xffffffffULL << IRDMAQPSQ_DESTQKEY_S)

#define IRDMAQPSQ_DESTQPN_S 32
#define IRDMAQPSQ_DESTQPN_M (0x00ffffffULL << IRDMAQPSQ_DESTQPN_S)

#define IRDMAQPSQ_AHID_S 0
#define IRDMAQPSQ_AHID_M (0x0001ffffULL << IRDMAQPSQ_AHID_S)

#define IRDMAQPSQ_INLINEDATAFLAG_S 57
#define IRDMAQPSQ_INLINEDATAFLAG_M BIT_ULL(IRDMAQPSQ_INLINEDATAFLAG_S)

#define IRDMA_INLINE_VALID_S 7

#define IRDMAQPSQ_INLINEDATALEN_S 48
#define IRDMAQPSQ_INLINEDATALEN_M \
	(0xffULL << IRDMAQPSQ_INLINEDATALEN_S)
#define IRDMAQPSQ_IMMDATAFLAG_S 47
#define IRDMAQPSQ_IMMDATAFLAG_M \
	BIT_ULL(IRDMAQPSQ_IMMDATAFLAG_S)
#define IRDMAQPSQ_REPORTRTT_S 46
#define IRDMAQPSQ_REPORTRTT_M \
	BIT_ULL(IRDMAQPSQ_REPORTRTT_S)

#define IRDMAQPSQ_IMMDATA_S 0
#define IRDMAQPSQ_IMMDATA_M \
	(0xffffffffffffffffULL << IRDMAQPSQ_IMMDATA_S)

/* rdma write */
#define IRDMAQPSQ_REMSTAG_S 0
#define IRDMAQPSQ_REMSTAG_M (0xffffffffULL << IRDMAQPSQ_REMSTAG_S)

#define IRDMAQPSQ_REMTO_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPSQ_REMTO_M IRDMA_CQPHC_QPCTX_M

/* memory window */
#define IRDMAQPSQ_STAGRIGHTS_S 48
#define IRDMAQPSQ_STAGRIGHTS_M (0x1fULL << IRDMAQPSQ_STAGRIGHTS_S)

#define IRDMAQPSQ_VABASEDTO_S 53
#define IRDMAQPSQ_VABASEDTO_M BIT_ULL(IRDMAQPSQ_VABASEDTO_S)

#define IRDMAQPSQ_MEMWINDOWTYPE_S 54
#define IRDMAQPSQ_MEMWINDOWTYPE_M BIT_ULL(IRDMAQPSQ_MEMWINDOWTYPE_S)

#define IRDMAQPSQ_MWLEN_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPSQ_MWLEN_M IRDMA_CQPHC_QPCTX_M

#define IRDMAQPSQ_PARENTMRSTAG_S 32
#define IRDMAQPSQ_PARENTMRSTAG_M \
	(0xffffffffULL << IRDMAQPSQ_PARENTMRSTAG_S)

#define IRDMAQPSQ_MWSTAG_S 0
#define IRDMAQPSQ_MWSTAG_M (0xffffffffULL << IRDMAQPSQ_MWSTAG_S)

#define IRDMAQPSQ_BASEVA_TO_FBO_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPSQ_BASEVA_TO_FBO_M IRDMA_CQPHC_QPCTX_M

/* Local Invalidate */
#define IRDMAQPSQ_LOCSTAG_S 0
#define IRDMAQPSQ_LOCSTAG_M (0xffffffffULL << IRDMAQPSQ_LOCSTAG_S)

/* Fast Register */
#define IRDMAQPSQ_STAGKEY_S 0
#define IRDMAQPSQ_STAGKEY_M (0xffULL << IRDMAQPSQ_STAGKEY_S)

#define IRDMAQPSQ_STAGINDEX_S 8
#define IRDMAQPSQ_STAGINDEX_M (0xffffffULL << IRDMAQPSQ_STAGINDEX_S)

#define IRDMAQPSQ_COPYHOSTPBLS_S 43
#define IRDMAQPSQ_COPYHOSTPBLS_M BIT_ULL(IRDMAQPSQ_COPYHOSTPBLS_S)

#define IRDMAQPSQ_LPBLSIZE_S 44
#define IRDMAQPSQ_LPBLSIZE_M (3ULL << IRDMAQPSQ_LPBLSIZE_S)

#define IRDMAQPSQ_HPAGESIZE_S 46
#define IRDMAQPSQ_HPAGESIZE_M (3ULL << IRDMAQPSQ_HPAGESIZE_S)

#define IRDMAQPSQ_STAGLEN_S 0
#define IRDMAQPSQ_STAGLEN_M (0x1ffffffffffULL << IRDMAQPSQ_STAGLEN_S)

#define IRDMAQPSQ_FIRSTPMPBLIDXLO_S 48
#define IRDMAQPSQ_FIRSTPMPBLIDXLO_M \
	(0xffffULL << IRDMAQPSQ_FIRSTPMPBLIDXLO_S)

#define IRDMAQPSQ_FIRSTPMPBLIDXHI_S 0
#define IRDMAQPSQ_FIRSTPMPBLIDXHI_M \
	(0xfffULL << IRDMAQPSQ_FIRSTPMPBLIDXHI_S)

#define IRDMAQPSQ_PBLADDR_S 12
#define IRDMAQPSQ_PBLADDR_M (0xfffffffffffffULL << IRDMAQPSQ_PBLADDR_S)

/* iwarp QP RQ WQE common fields */
#define IRDMAQPRQ_ADDFRAGCNT_S IRDMAQPSQ_ADDFRAGCNT_S
#define IRDMAQPRQ_ADDFRAGCNT_M IRDMAQPSQ_ADDFRAGCNT_M

#define IRDMAQPRQ_VALID_S IRDMAQPSQ_VALID_S
#define IRDMAQPRQ_VALID_M IRDMAQPSQ_VALID_M

#define IRDMAQPRQ_COMPLCTX_S IRDMA_CQPHC_QPCTX_S
#define IRDMAQPRQ_COMPLCTX_M IRDMA_CQPHC_QPCTX_M

#define IRDMAQPRQ_FRAG_LEN_S IRDMAQPSQ_FRAG_LEN_S
#define IRDMAQPRQ_FRAG_LEN_M IRDMAQPSQ_FRAG_LEN_M

#define IRDMAQPRQ_STAG_S IRDMAQPSQ_FRAG_STAG_S
#define IRDMAQPRQ_STAG_M IRDMAQPSQ_FRAG_STAG_M

#define IRDMAQPRQ_TO_S IRDMAQPSQ_FRAG_TO_S
#define IRDMAQPRQ_TO_M IRDMAQPSQ_FRAG_TO_M

/* Query FPM CQP buf */
#define IRDMA_QUERY_FPM_MAX_QPS_S 0
#define IRDMA_QUERY_FPM_MAX_QPS_M \
	(0x7ffffULL << IRDMA_QUERY_FPM_MAX_QPS_S)

#define IRDMA_QUERY_FPM_MAX_CQS_S 0
#define IRDMA_QUERY_FPM_MAX_CQS_M \
	(0xfffffULL << IRDMA_QUERY_FPM_MAX_CQS_S)

#define IRDMA_QUERY_FPM_FIRST_PE_SD_INDEX_S 0
#define IRDMA_QUERY_FPM_FIRST_PE_SD_INDEX_M \
	(0x3fffULL << IRDMA_QUERY_FPM_FIRST_PE_SD_INDEX_S)

#define IRDMA_QUERY_FPM_MAX_PE_SDS_S 32
#define IRDMA_QUERY_FPM_MAX_PE_SDS_M \
	(0x3fffULL << IRDMA_QUERY_FPM_MAX_PE_SDS_S)

#define IRDMA_QUERY_FPM_MAX_CEQS_S 0
#define IRDMA_QUERY_FPM_MAX_CEQS_M \
	(0x3ffULL << IRDMA_QUERY_FPM_MAX_CEQS_S)

#define IRDMA_QUERY_FPM_XFBLOCKSIZE_S 32
#define IRDMA_QUERY_FPM_XFBLOCKSIZE_M \
	(0xffffffffULL << IRDMA_QUERY_FPM_XFBLOCKSIZE_S)

#define IRDMA_QUERY_FPM_Q1BLOCKSIZE_S 32
#define IRDMA_QUERY_FPM_Q1BLOCKSIZE_M \
	(0xffffffffULL << IRDMA_QUERY_FPM_Q1BLOCKSIZE_S)

#define IRDMA_QUERY_FPM_HTMULTIPLIER_S 16
#define IRDMA_QUERY_FPM_HTMULTIPLIER_M \
	(0xfULL << IRDMA_QUERY_FPM_HTMULTIPLIER_S)

#define IRDMA_QUERY_FPM_TIMERBUCKET_S 32
#define IRDMA_QUERY_FPM_TIMERBUCKET_M \
	(0xffFFULL << IRDMA_QUERY_FPM_TIMERBUCKET_S)

#define IRDMA_QUERY_FPM_RRFBLOCKSIZE_S 32
#define IRDMA_QUERY_FPM_RRFBLOCKSIZE_M \
	(0xffffffffULL << IRDMA_QUERY_FPM_RRFBLOCKSIZE_S)

#define IRDMA_QUERY_FPM_RRFFLBLOCKSIZE_S 32
#define IRDMA_QUERY_FPM_RRFFLBLOCKSIZE_M \
	(0xffffffffULL << IRDMA_QUERY_FPM_RRFFLBLOCKSIZE_S)

#define IRDMA_QUERY_FPM_OOISCFBLOCKSIZE_S 32
#define IRDMA_QUERY_FPM_OOISCFBLOCKSIZE_M \
	(0xffffffffULL << IRDMA_QUERY_FPM_OOISCFBLOCKSIZE_S)

/* Static HMC pages allocated buf */
#define IRDMA_SHMC_PAGE_ALLOCATED_HMC_FN_ID_S 0
#define IRDMA_SHMC_PAGE_ALLOCATED_HMC_FN_ID_M \
	(0x3fULL << IRDMA_SHMC_PAGE_ALLOCATED_HMC_FN_ID_S)

#define IRDMA_GET_CURRENT_AEQ_ELEM(_aeq) \
	( \
		(_aeq)->aeqe_base[IRDMA_RING_CURRENT_TAIL((_aeq)->aeq_ring)].buf \
	)

#define IRDMA_GET_CURRENT_CEQ_ELEM(_ceq) \
	( \
		(_ceq)->ceqe_base[IRDMA_RING_CURRENT_TAIL((_ceq)->ceq_ring)].buf \
	)

#define IRDMA_CQP_INIT_WQE(wqe) memset(wqe, 0, 64)

#define IRDMA_GET_CURRENT_CQ_ELEM(_cq) \
	( \
		(_cq)->cq_base[IRDMA_RING_CURRENT_HEAD((_cq)->cq_ring)].buf  \
	)
#define IRDMA_GET_CURRENT_EXTENDED_CQ_ELEM(_cq) \
	( \
		((struct irdma_extended_cqe *) \
		((_cq)->cq_base))[IRDMA_RING_CURRENT_HEAD((_cq)->cq_ring)].buf \
	)

#define IRDMA_RING_INIT(_ring, _size) \
	{ \
		(_ring).head = 0; \
		(_ring).tail = 0; \
		(_ring).size = (_size); \
	}
#define IRDMA_RING_SIZE(_ring) ((_ring).size)
#define IRDMA_RING_CURRENT_HEAD(_ring) ((_ring).head)
#define IRDMA_RING_CURRENT_TAIL(_ring) ((_ring).tail)

#define IRDMA_RING_MOVE_HEAD(_ring, _retcode) \
	{ \
		register u32 size; \
		size = (_ring).size;  \
		if (!IRDMA_RING_FULL_ERR(_ring)) { \
			(_ring).head = ((_ring).head + 1) % size; \
			(_retcode) = 0; \
		} else { \
			(_retcode) = IRDMA_ERR_RING_FULL; \
		} \
	}
#define IRDMA_RING_MOVE_HEAD_BY_COUNT(_ring, _count, _retcode) \
	{ \
		register u32 size; \
		size = (_ring).size; \
		if ((IRDMA_RING_USED_QUANTA(_ring) + (_count)) < size) { \
			(_ring).head = ((_ring).head + (_count)) % size; \
			(_retcode) = 0; \
		} else { \
			(_retcode) = IRDMA_ERR_RING_FULL; \
		} \
	}
#define IRDMA_SQ_RING_MOVE_HEAD(_ring, _retcode) \
	{ \
		register u32 size; \
		size = (_ring).size;  \
		if (!IRDMA_SQ_RING_FULL_ERR(_ring)) { \
			(_ring).head = ((_ring).head + 1) % size; \
			(_retcode) = 0; \
		} else { \
			(_retcode) = IRDMA_ERR_RING_FULL; \
		} \
	}
#define IRDMA_SQ_RING_MOVE_HEAD_BY_COUNT(_ring, _count, _retcode) \
	{ \
		register u32 size; \
		size = (_ring).size; \
		if ((IRDMA_RING_USED_QUANTA(_ring) + (_count)) < (size - 256)) { \
			(_ring).head = ((_ring).head + (_count)) % size; \
			(_retcode) = 0; \
		} else { \
			(_retcode) = IRDMA_ERR_RING_FULL; \
		} \
	}
#define IRDMA_RING_MOVE_HEAD_BY_COUNT_NOCHECK(_ring, _count) \
	(_ring).head = ((_ring).head + (_count)) % (_ring).size

#define IRDMA_RING_MOVE_TAIL(_ring) \
	(_ring).tail = ((_ring).tail + 1) % (_ring).size

#define IRDMA_RING_MOVE_HEAD_NOCHECK(_ring) \
	(_ring).head = ((_ring).head + 1) % (_ring).size

#define IRDMA_RING_MOVE_TAIL_BY_COUNT(_ring, _count) \
	(_ring).tail = ((_ring).tail + (_count)) % (_ring).size

#define IRDMA_RING_SET_TAIL(_ring, _pos) \
	(_ring).tail = (_pos) % (_ring).size

#define IRDMA_RING_FULL_ERR(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) == ((_ring).size - 1))  \
	)

#define IRDMA_ERR_RING_FULL2(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) == ((_ring).size - 2))  \
	)

#define IRDMA_ERR_RING_FULL3(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) == ((_ring).size - 3))  \
	)

#define IRDMA_SQ_RING_FULL_ERR(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) == ((_ring).size - 257))  \
	)

#define IRDMA_ERR_SQ_RING_FULL2(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) == ((_ring).size - 258))  \
	)
#define IRDMA_ERR_SQ_RING_FULL3(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) == ((_ring).size - 259))  \
	)
#define IRDMA_RING_MORE_WORK(_ring) \
	( \
		(IRDMA_RING_USED_QUANTA(_ring) != 0) \
	)

#define IRDMA_RING_USED_QUANTA(_ring) \
	( \
		(((_ring).head + (_ring).size - (_ring).tail) % (_ring).size) \
	)

#define IRDMA_RING_FREE_QUANTA(_ring) \
	( \
		((_ring).size - IRDMA_RING_USED_QUANTA(_ring) - 1) \
	)

#define IRDMA_SQ_RING_FREE_QUANTA(_ring) \
	( \
		((_ring).size - IRDMA_RING_USED_QUANTA(_ring) - 257) \
	)

#define IRDMA_ATOMIC_RING_MOVE_HEAD(_ring, index, _retcode) \
	{ \
		index = IRDMA_RING_CURRENT_HEAD(_ring); \
		IRDMA_RING_MOVE_HEAD(_ring, _retcode); \
	}

enum irdma_qp_wqe_size {
	IRDMA_WQE_SIZE_32  = 32,
	IRDMA_WQE_SIZE_64  = 64,
	IRDMA_WQE_SIZE_96  = 96,
	IRDMA_WQE_SIZE_128 = 128,
	IRDMA_WQE_SIZE_256 = 256,
};

enum irdma_ws_node_op {
	IRDMA_ADD_NODE = 0,
	IRDMA_MODIFY_NODE,
	IRDMA_DEL_NODE,
	IRDMA_FAILOVER_START,
	IRDMA_FAILOVER_COMPLETE,
};

enum {	IRDMA_Q_ALIGNMENT_M		 = (128 - 1),
	IRDMA_AEQ_ALIGNMENT_M		 = (256 - 1),
	IRDMA_Q2_ALIGNMENT_M		 = (256 - 1),
	IRDMA_CEQ_ALIGNMENT_M		 = (256 - 1),
	IRDMA_CQ0_ALIGNMENT_M		 = (256 - 1),
	IRDMA_HOST_CTX_ALIGNMENT_M	 = (4 - 1),
	IRDMA_SHADOWAREA_M		 = (128 - 1),
	IRDMA_FPM_QUERY_BUF_ALIGNMENT_M	 = (4 - 1),
	IRDMA_FPM_COMMIT_BUF_ALIGNMENT_M = (4 - 1),
};

enum irdma_alignment {
	IRDMA_CQP_ALIGNMENT	    = 0x200,
	IRDMA_AEQ_ALIGNMENT	    = 0x100,
	IRDMA_CEQ_ALIGNMENT	    = 0x100,
	IRDMA_CQ0_ALIGNMENT	    = 0x100,
	IRDMA_SD_BUF_ALIGNMENT      = 0x80,
	IRDMA_FEATURE_BUF_ALIGNMENT = 0x8,
};

enum icrdma_protocol_used {
	ICRDMA_ANY_PROTOCOL	   = 0,
	ICRDMA_IWARP_PROTOCOL_ONLY = 1,
	ICRDMA_ROCE_PROTOCOL_ONLY  = 2,
};

/**
 * set_64bit_val - set 64 bit value to hw wqe
 * @wqe_words: wqe addr to write
 * @byte_index: index in wqe
 * @val: value to write
 **/
static inline void set_64bit_val(__le64 *wqe_words, u32 byte_index, u64 val)
{
	wqe_words[byte_index >> 3] = cpu_to_le64(val);
}

/**
 * set_32bit_val - set 32 bit value to hw wqe
 * @wqe_words: wqe addr to write
 * @byte_index: index in wqe
 * @val: value to write
 **/
static inline void set_32bit_val(u32 *wqe_words, u32 byte_index, u32 val)
{
	wqe_words[byte_index >> 2] = val;
}

/**
 * get_64bit_val - read 64 bit value from wqe
 * @wqe_words: wqe addr
 * @byte_index: index to read from
 * @val: read value
 **/
static inline void get_64bit_val(__le64 *wqe_words, u32 byte_index, u64 *val)
{
	*val = le64_to_cpu(wqe_words[byte_index >> 3]);
}

/**
 * get_32bit_val - read 32 bit value from wqe
 * @wqe_words: wqe addr
 * @byte_index: index to reaad from
 * @val: return 32 bit value
 **/
static inline void get_32bit_val(u32 *wqe_words, u32 byte_index, u32 *val)
{
	*val = wqe_words[byte_index >> 2];
}
#endif /* IRDMA_DEFS_H */
