/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
#ifndef DISTRO_VER_H
#define DISTRO_VER_H

#if defined(RHEL_RELEASE_CODE)
#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(8, 2))
#define RHEL_8_2
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(8, 1))
#define RHEL_8_1
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(7, 8))
#define RHEL_7_8
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(7, 7))
#define RHEL_7_7
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(8, 0))
#define RHEL_8_0
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(7, 6))
#define RHEL_7_6
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(7, 5))
#define RHEL_7_5
#endif

#if (RHEL_RELEASE_CODE == RHEL_RELEASE_VERSION(7, 4))
#define RHEL_7_4
#endif

#endif /* RHEL_RELEASE_CODE */

#ifdef CONFIG_SUSE_KERNEL
#ifndef SLE_VERSION
#define SLE_VERSION(a, b, c)	KERNEL_VERSION(a, b, c)
#endif
#define SLE_LOCALVERSION(a, b, c) KERNEL_VERSION(a, b, c)

#if (LINUX_VERSION_CODE == KERNEL_VERSION(4, 12, 14) && \
	(SLE_LOCALVERSION_CODE == KERNEL_VERSION(94, 41, 0) || \
	(SLE_LOCALVERSION_CODE >= KERNEL_VERSION(95, 0, 0) && \
	SLE_LOCALVERSION_CODE < KERNEL_VERSION(96, 0, 0))))
/* SLES12 SP4 GM is 4.12.14-94.41 and update kernel is 4.12.14-95.x. */
#define SLE_VERSION_CODE SLE_VERSION(12, 4, 0)
#elif (LINUX_VERSION_CODE == KERNEL_VERSION(4, 12, 14) && \
	(SLE_LOCALVERSION_CODE == KERNEL_VERSION(23, 0, 0) || \
	 SLE_LOCALVERSION_CODE == KERNEL_VERSION(2, 0, 0) || \
	 SLE_LOCALVERSION_CODE == KERNEL_VERSION(136, 0, 0) || \
	 (SLE_LOCALVERSION_CODE >= KERNEL_VERSION(25, 0, 0) && \
	  SLE_LOCALVERSION_CODE < KERNEL_VERSION(25, 23, 0))))
#define SLE_VERSION_CODE SLE_VERSION(15, 0, 0)
#elif (LINUX_VERSION_CODE == KERNEL_VERSION(4, 12, 14) && \
	SLE_LOCALVERSION_CODE >= KERNEL_VERSION(25, 23, 0))
/* SLES15 SP1 Beta1 is 4.12.14-25.23 */
#define SLE_VERSION_CODE SLE_VERSION(15, 1, 0)
#elif (LINUX_VERSION_CODE == KERNEL_VERSION(5, 3, 18) && \
SLE_LOCALVERSION_CODE >= KERNEL_VERSION(16, 0, 0))
/* SLES15 SP2 snapshot 15 is  5.3.18-16 */
#define SLE_VERSION_CODE SLE_VERSION(15, 2, 0)
#define SLES_15_SP_2
#endif /* LINUX_VERSION_CODE == KERNEL_VERSION(x,y,z) */

#if (SLE_VERSION_CODE == SLE_VERSION(15, 0, 0))
#define SLES_15
#endif

#if (SLE_VERSION_CODE == SLE_VERSION(15, 1, 0))
#define SLES_15_SP_1
#endif

#if (SLE_VERSION_CODE == SLE_VERSION(12, 4, 0))
#define SLES_12_SP_4
#endif

#endif /* CONFIG_SUSE_KERENL */

#endif /* DISTRO_VER_H */
