/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2020 Intel Corporation */
#ifndef OFED_KCOMPAT_H
#define OFED_KCOMPAT_H

#include <linux/sizes.h>

#if defined(RHEL_7_5) || defined(RHEL_7_6)
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_1
#define DESTROY_AH_VER_1
#define SET_ROCE_CM_INFO_VER_1
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define IRDMA_SET_DRIVER_ID

#define kc_ib_register_device(device, name) ib_register_device(device, NULL)
#define kc_typeq_ib_wr
#define kc_deref_sgid_attr(sgid_attr)        (sgid_attr.ndev)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext((ibpd)->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define set_ibdev_dma_device(ibdev, dev)
#define ah_attr_to_dmac(attr) ((attr).roce.dmac)

#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define rdma_query_gid(ibdev, port, index, gid) \
	ib_get_cached_gid(ibdev, port, index, gid, NULL)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	ib_gid_to_network_type(gid_type, gid)

#define set_max_sge(props, rf)  \
	((props)->max_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags)

#define kc_set_props_ip_gid_caps(props) \
	((props)->port_cap_flags  |= IB_PORT_IP_BASED_GIDS)

#define kc_set_ibdev_add_del_gid(ibdev)

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)

#endif /* RHEL_7_5 */

#ifdef RHEL_7_4
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_1
#define DESTROY_AH_VER_1
#define SET_ROCE_CM_INFO_VER_1
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define IRDMA_SET_DRIVER_ID

#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define kc_ib_register_device(device, name) ib_register_device(device, NULL)
#define kc_typeq_ib_wr
#define kc_deref_sgid_attr(sgid_attr)        (sgid_attr.ndev)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext((ibpd)->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define rdma_query_gid(ibdev, port, index, gid) \
	ib_get_cached_gid(ibdev, port, index, gid, NULL)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	ib_gid_to_network_type(gid_type, gid)

#define set_max_sge(props, rf)  \
	((props)->max_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags)

#define kc_set_props_ip_gid_caps(props) \
	((props)->port_cap_flags  |= IB_PORT_IP_BASED_GIDS)

#define kc_set_ibdev_add_del_gid(ibdev)

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)

#define set_ibdev_dma_device(ibdev, dev)        \
	ibdev.dma_device = dev

#endif /* RHEL_7_4 */

#if defined(SLES_15) || defined(SLES_12_SP_4)
enum ib_port_phys_state {
	IB_PORT_PHYS_STATE_SLEEP = 1,
	IB_PORT_PHYS_STATE_POLLING = 2,
	IB_PORT_PHYS_STATE_DISABLED = 3,
	IB_PORT_PHYS_STATE_PORT_CONFIGURATION_TRAINING = 4,
	IB_PORT_PHYS_STATE_LINK_UP = 5,
	IB_PORT_PHYS_STATE_LINK_ERROR_RECOVERY = 6,
	IB_PORT_PHYS_STATE_PHY_TEST = 7,
};

struct ib_ucontext *irdma_alloc_ucontext(struct ib_device *ibdev, struct ib_udata *udata);
int irdma_dealloc_ucontext(struct ib_ucontext *context);
struct ib_pd *irdma_alloc_pd(struct ib_device *ibdev, struct ib_ucontext *context, struct ib_udata *udata);
int irdma_dealloc_pd(struct ib_pd *ibpd);
int irdma_add_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  const union ib_gid *gid,
		  const struct ib_gid_attr *attr,
		  void **context);
int irdma_del_gid(struct ib_device *device,
		  u8 port_num,
		  unsigned int index,
		  void **context);

#define CREATE_AH_VER_1
#define DESTROY_AH_VER_1
#define SET_ROCE_CM_INFO_VER_1
#define IRDMA_ADD_DEL_GID
#define IB_UMEM_GET_V1
#define ALLOC_PD_VER_1
#define DEALLOC_PD_VER_1
#define ALLOC_UCONTEXT_VER_1
#define DEALLOC_UCONTEXT_VER_1
#define IRDMA_SET_DRIVER_ID

#define kc_ib_register_device(device, name) ib_register_device(device, NULL)
#define kc_typeq_ib_wr
#define kc_deref_sgid_attr(sgid_attr)        (sgid_attr.ndev)
#define kc_rdma_udata_to_drv_context(ibpd, udata) to_ucontext((ibpd)->uobject->context)
#define ib_device_put(dev)
#define devlink_params_publish(devlink)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp)
#define kc_get_ucontext(udata) to_ucontext(context)
#define set_ibdev_dma_device(ibdev, dev)

#define ah_attr_to_dmac(attr) ((attr).roce.dmac)

#define ib_alloc_device(irdma_device, ibdev) \
	((struct irdma_device *)ib_alloc_device(sizeof(struct irdma_device)))

#define rdma_query_gid(ibdev, port, index, gid) \
	ib_get_cached_gid(ibdev, port, index, gid, NULL)

#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid) \
	ib_gid_to_network_type(gid_type, gid)

#define set_max_sge(props, rf)  \
	((props)->max_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags)

#define kc_set_props_ip_gid_caps(props) \
	((props)->port_cap_flags  |= IB_PORT_IP_BASED_GIDS)

#define kc_set_ibdev_add_del_gid(ibdev)

#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) \
	ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll)

#define ib_umem_get(udata, addr, size, access, dmasync) \
	ib_umem_get(pd->uobject->context, addr, size, access, dmasync)
#endif /* SLES_15 */

#endif /* OFED_KCOMPAT_H */
