/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2019 Intel Corporation */
#ifndef IRDMA_UDA_D_H
#define IRDMA_UDA_D_H

/* L4 packet type */
#define IRDMA_E_UDA_SQ_L4T_UNKNOWN	0
#define IRDMA_E_UDA_SQ_L4T_TCP		1
#define IRDMA_E_UDA_SQ_L4T_SCTP		2
#define IRDMA_E_UDA_SQ_L4T_UDP		3

/* Inner IP header type */
#define IRDMA_E_UDA_SQ_IIPT_UNKNOWN		0
#define IRDMA_E_UDA_SQ_IIPT_IPV6		1
#define IRDMA_E_UDA_SQ_IIPT_IPV4_NO_CSUM	2
#define IRDMA_E_UDA_SQ_IIPT_IPV4_CSUM		3

/* UDA defined fields for transmit descriptors */
#define IRDMA_UDA_QPSQ_PUSHWQE_S 56
#define IRDMA_UDA_QPSQ_PUSHWQE_M BIT_ULL(IRDMA_UDA_QPSQ_PUSHWQE_S)

#define IRDMA_UDA_QPSQ_INLINEDATAFLAG_S 57
#define IRDMA_UDA_QPSQ_INLINEDATAFLAG_M \
	BIT_ULL(IRDMA_UDA_QPSQ_INLINEDATAFLAG_S)

#define IRDMA_UDA_QPSQ_INLINEDATALEN_S 48
#define IRDMA_UDA_QPSQ_INLINEDATALEN_M \
	((u64)0xff << IRDMA_UDA_QPSQ_INLINEDATALEN_S)

#define IRDMA_UDA_QPSQ_ADDFRAGCNT_S 38
#define IRDMA_UDA_QPSQ_ADDFRAGCNT_M \
	((u64)0x0F << IRDMA_UDA_QPSQ_ADDFRAGCNT_S)

#define IRDMA_UDA_QPSQ_IPFRAGFLAGS_S 42
#define IRDMA_UDA_QPSQ_IPFRAGFLAGS_M \
	((u64)0x3 << IRDMA_UDA_QPSQ_IPFRAGFLAGS_S)

#define IRDMA_UDA_QPSQ_NOCHECKSUM_S 45
#define IRDMA_UDA_QPSQ_NOCHECKSUM_M \
	BIT_ULL(IRDMA_UDA_QPSQ_NOCHECKSUM_S)

#define IRDMA_UDA_QPSQ_AHIDXVALID_S 46
#define IRDMA_UDA_QPSQ_AHIDXVALID_M \
	BIT_ULL(IRDMA_UDA_QPSQ_AHIDXVALID_S)

#define IRDMA_UDA_QPSQ_LOCAL_FENCE_S 61
#define IRDMA_UDA_QPSQ_LOCAL_FENCE_M \
	BIT_ULL(IRDMA_UDA_QPSQ_LOCAL_FENCE_S)

#define IRDMA_UDA_QPSQ_AHIDX_S 0
#define IRDMA_UDA_QPSQ_AHIDX_M ((u64)0x1ffff << IRDMA_UDA_QPSQ_AHIDX_S)

#define IRDMA_UDA_QPSQ_PROTOCOL_S 16
#define IRDMA_UDA_QPSQ_PROTOCOL_M \
	((u64)0xff << IRDMA_UDA_QPSQ_PROTOCOL_S)

#define IRDMA_UDA_QPSQ_EXTHDRLEN_S 32
#define IRDMA_UDA_QPSQ_EXTHDRLEN_M \
	((u64)0x1ff << IRDMA_UDA_QPSQ_EXTHDRLEN_S)

#define IRDMA_UDA_QPSQ_MULTICAST_S 63
#define IRDMA_UDA_QPSQ_MULTICAST_M \
	BIT_ULL(IRDMA_UDA_QPSQ_MULTICAST_S)

#define IRDMA_UDA_QPSQ_MACLEN_S 56
#define IRDMA_UDA_QPSQ_MACLEN_M \
	((u64)0x7f << IRDMA_UDA_QPSQ_MACLEN_S)
#define IRDMA_UDA_QPSQ_MACLEN_LINE 2

#define IRDMA_UDA_QPSQ_IPLEN_S 48
#define IRDMA_UDA_QPSQ_IPLEN_M \
	((u64)0x7f << IRDMA_UDA_QPSQ_IPLEN_S)
#define IRDMA_UDA_QPSQ_IPLEN_LINE 2

#define IRDMA_UDA_QPSQ_L4T_S 30
#define IRDMA_UDA_QPSQ_L4T_M ((u64)0x3 << IRDMA_UDA_QPSQ_L4T_S)
#define IRDMA_UDA_QPSQ_L4T_LINE 2

#define IRDMA_UDA_QPSQ_IIPT_S 28
#define IRDMA_UDA_QPSQ_IIPT_M ((u64)0x3 << IRDMA_UDA_QPSQ_IIPT_S)
#define IRDMA_UDA_QPSQ_IIPT_LINE 2

#define IRDMA_UDA_QPSQ_DO_LPB_LINE 3

#define IRDMA_UDA_QPSQ_FWD_PROG_CONFIRM_S 45
#define IRDMA_UDA_QPSQ_FWD_PROG_CONFIRM_M \
	BIT_ULL(IRDMA_UDA_QPSQ_FWD_PROG_CONFIRM_S)
#define IRDMA_UDA_QPSQ_FWD_PROG_CONFIRM_LINE 3

#define IRDMA_UDA_QPSQ_IMMDATA_S 0
#define IRDMA_UDA_QPSQ_IMMDATA_M \
	((u64)0xffffffffffffffff << IRDMA_UDA_QPSQ_IMMDATA_S)

/* Byte Offset 0 */
#define IRDMA_UDAQPC_IPV4_S 3
#define IRDMA_UDAQPC_IPV4_M BIT_ULL(IRDMAQPC_IPV4_S)

#define IRDMA_UDAQPC_INSERTVLANTAG_S 5
#define IRDMA_UDAQPC_INSERTVLANTAG_M BIT_ULL(IRDMA_UDAQPC_INSERTVLANTAG_S)

#define IRDMA_UDAQPC_ISQP1_S 6
#define IRDMA_UDAQPC_ISQP1_M BIT_ULL(IRDMA_UDAQPC_ISQP1_S)

#define IRDMA_UDAQPC_RQWQESIZE_S IRDMAQPC_RQWQESIZE_S
#define IRDMA_UDAQPC_RQWQESIZE_M IRDMAQPC_RQWQESIZE_M

#define IRDMA_UDAQPC_ECNENABLE_S 14
#define IRDMA_UDAQPC_ECNENABLE_M BIT_ULL(IRDMA_UDAQPC_ECNENABLE_S)

#define IRDMA_UDAQPC_PDINDEXHI_S 20
#define IRDMA_UDAQPC_PDINDEXHI_M ((u64)3 << IRDMA_UDAQPC_PDINDEXHI_S)

#define IRDMA_UDAQPC_DCTCPENABLE_S 25
#define IRDMA_UDAQPC_DCTCPENABLE_M BIT_ULL(IRDMA_UDAQPC_DCTCPENABLE_S)

#define IRDMA_UDAQPC_RCVTPHEN_S IRDMAQPC_RCVTPHEN_S
#define IRDMA_UDAQPC_RCVTPHEN_M IRDMAQPC_RCVTPHEN_M

#define IRDMA_UDAQPC_XMITTPHEN_S IRDMAQPC_XMITTPHEN_S
#define IRDMA_UDAQPC_XMITTPHEN_M IRDMAQPC_XMITTPHEN_M

#define IRDMA_UDAQPC_RQTPHEN_S IRDMAQPC_RQTPHEN_S
#define IRDMA_UDAQPC_RQTPHEN_M IRDMAQPC_RQTPHEN_M

#define IRDMA_UDAQPC_SQTPHEN_S IRDMAQPC_SQTPHEN_S
#define IRDMA_UDAQPC_SQTPHEN_M IRDMAQPC_SQTPHEN_M

#define IRDMA_UDAQPC_PPIDX_S IRDMAQPC_PPIDX_S
#define IRDMA_UDAQPC_PPIDX_M IRDMAQPC_PPIDX_M

#define IRDMA_UDAQPC_PMENA_S IRDMAQPC_PMENA_S
#define IRDMA_UDAQPC_PMENA_M IRDMAQPC_PMENA_M

#define IRDMA_UDAQPC_INSERTTAG2_S 11
#define IRDMA_UDAQPC_INSERTTAG2_M BIT_ULL(IRDMA_UDAQPC_INSERTTAG2_S)

#define IRDMA_UDAQPC_INSERTTAG3_S 14
#define IRDMA_UDAQPC_INSERTTAG3_M BIT_ULL(IRDMA_UDAQPC_INSERTTAG3_S)

#define IRDMA_UDAQPC_RQSIZE_S IRDMAQPC_RQSIZE_S
#define IRDMA_UDAQPC_RQSIZE_M IRDMAQPC_RQSIZE_M

#define IRDMA_UDAQPC_SQSIZE_S IRDMAQPC_SQSIZE_S
#define IRDMA_UDAQPC_SQSIZE_M IRDMAQPC_SQSIZE_M

#define IRDMA_UDAQPC_TXCQNUM_S IRDMAQPC_TXCQNUM_S
#define IRDMA_UDAQPC_TXCQNUM_M IRDMAQPC_TXCQNUM_M

#define IRDMA_UDAQPC_RXCQNUM_S IRDMAQPC_RXCQNUM_S
#define IRDMA_UDAQPC_RXCQNUM_M IRDMAQPC_RXCQNUM_M

#define IRDMA_UDAQPC_QPCOMPCTX_S IRDMAQPC_QPCOMPCTX_S
#define IRDMA_UDAQPC_QPCOMPCTX_M IRDMAQPC_QPCOMPCTX_M

#define IRDMA_UDAQPC_SQTPHVAL_S IRDMAQPC_SQTPHVAL_S
#define IRDMA_UDAQPC_SQTPHVAL_M IRDMAQPC_SQTPHVAL_M

#define IRDMA_UDAQPC_RQTPHVAL_S IRDMAQPC_RQTPHVAL_S
#define IRDMA_UDAQPC_RQTPHVAL_M IRDMAQPC_RQTPHVAL_M

#define IRDMA_UDAQPC_QSHANDLE_S IRDMAQPC_QSHANDLE_S
#define IRDMA_UDAQPC_QSHANDLE_M IRDMAQPC_QSHANDLE_M

#define IRDMA_UDAQPC_RQHDRRINGBUFSIZE_S 48
#define IRDMA_UDAQPC_RQHDRRINGBUFSIZE_M \
	((u64)0x3 << IRDMA_UDAQPC_RQHDRRINGBUFSIZE_S)

#define IRDMA_UDAQPC_SQHDRRINGBUFSIZE_S 32
#define IRDMA_UDAQPC_SQHDRRINGBUFSIZE_M \
	((u64)0x3 << IRDMA_UDAQPC_SQHDRRINGBUFSIZE_S)

#define IRDMA_UDAQPC_PRIVILEGEENABLE_S 25
#define IRDMA_UDAQPC_PRIVILEGEENABLE_M \
	BIT_ULL(IRDMA_UDAQPC_PRIVILEGEENABLE_S)

#define IRDMA_UDAQPC_USE_STATISTICS_INSTANCE_S 26
#define IRDMA_UDAQPC_USE_STATISTICS_INSTANCE_M \
	BIT_ULL(IRDMA_UDAQPC_USE_STATISTICS_INSTANCE_S)

#define IRDMA_UDAQPC_STATISTICS_INSTANCE_INDEX_S 0
#define IRDMA_UDAQPC_STATISTICS_INSTANCE_INDEX_M \
	((u64)0x7F << IRDMA_UDAQPC_STATISTICS_INSTANCE_INDEX_S)

#define IRDMA_UDAQPC_PRIVHDRGENENABLE_S 0
#define IRDMA_UDAQPC_PRIVHDRGENENABLE_M \
	BIT_ULL(IRDMA_UDAQPC_PRIVHDRGENENABLE_S)

#define IRDMA_UDAQPC_RQHDRSPLITENABLE_S 3
#define IRDMA_UDAQPC_RQHDRSPLITENABLE_M \
	BIT_ULL(IRDMA_UDAQPC_RQHDRSPLITENABLE_S)

#define IRDMA_UDAQPC_RQHDRRINGBUFENABLE_S 2
#define IRDMA_UDAQPC_RQHDRRINGBUFENABLE_M \
	BIT_ULL(IRDMA_UDAQPC_RQHDRRINGBUFENABLE_S)

#define IRDMA_UDAQPC_SQHDRRINGBUFENABLE_S 1
#define IRDMA_UDAQPC_SQHDRRINGBUFENABLE_M \
	BIT_ULL(IRDMA_UDAQPC_SQHDRRINGBUFENABLE_S)

#define IRDMA_UDAQPC_IPID_S 32
#define IRDMA_UDAQPC_IPID_M ((u64)0xffff << IRDMA_UDAQPC_IPID_S)

#define IRDMA_UDAQPC_SNDMSS_S 16
#define IRDMA_UDAQPC_SNDMSS_M ((u64)0x3fff << IRDMA_UDAQPC_SNDMSS_S)

#define IRDMA_UDAQPC_VLANTAG_S 0
#define IRDMA_UDAQPC_VLANTAG_M  ((u64)0xffff << IRDMA_UDAQPC_VLANTAG_S)

/* Address Handle */
#define IRDMA_UDA_CQPSQ_MAV_PDINDEXHI_S 20
#define IRDMA_UDA_CQPSQ_MAV_PDINDEXHI_M \
	((u64)0x3 << IRDMA_UDA_CQPSQ_MAV_PDINDEXHI_S)

#define IRDMA_UDA_CQPSQ_MAV_PDINDEXLO_S 48
#define IRDMA_UDA_CQPSQ_MAV_PDINDEXLO_M \
	((u64)0xffff << IRDMA_UDA_CQPSQ_MAV_PDINDEXLO_S)

#define IRDMA_UDA_CQPSQ_MAV_SRCMACADDRINDEX_S 24
#define IRDMA_UDA_CQPSQ_MAV_SRCMACADDRINDEX_M \
	((u64)0x3f << IRDMA_UDA_CQPSQ_MAV_SRCMACADDRINDEX_S)

#define IRDMA_UDA_CQPSQ_MAV_ARPINDEX_S 48
#define IRDMA_UDA_CQPSQ_MAV_ARPINDEX_M \
	((u64)0xffff << IRDMA_UDA_CQPSQ_MAV_ARPINDEX_S)

#define IRDMA_UDA_CQPSQ_MAV_TC_S 32
#define IRDMA_UDA_CQPSQ_MAV_TC_M ((u64)0xff << IRDMA_UDA_CQPSQ_MAV_TC_S)

#define IRDMA_UDA_CQPSQ_MAV_HOPLIMIT_S 32
#define IRDMA_UDA_CQPSQ_MAV_HOPLIMIT_M \
	((u64)0xff << IRDMA_UDA_CQPSQ_MAV_HOPLIMIT_S)

#define IRDMA_UDA_CQPSQ_MAV_FLOWLABEL_S 0
#define IRDMA_UDA_CQPSQ_MAV_FLOWLABEL_M \
	((u64)0xfffff << IRDMA_UDA_CQPSQ_MAV_FLOWLABEL_S)

#define IRDMA_UDA_CQPSQ_MAV_ADDR0_S 32
#define IRDMA_UDA_CQPSQ_MAV_ADDR0_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_MAV_ADDR0_S)

#define IRDMA_UDA_CQPSQ_MAV_ADDR1_S 0
#define IRDMA_UDA_CQPSQ_MAV_ADDR1_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_MAV_ADDR1_S)

#define IRDMA_UDA_CQPSQ_MAV_ADDR2_S 32
#define IRDMA_UDA_CQPSQ_MAV_ADDR2_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_MAV_ADDR2_S)

#define IRDMA_UDA_CQPSQ_MAV_ADDR3_S 0
#define IRDMA_UDA_CQPSQ_MAV_ADDR3_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_MAV_ADDR3_S)

#define IRDMA_UDA_CQPSQ_MAV_WQEVALID_S 63
#define IRDMA_UDA_CQPSQ_MAV_WQEVALID_M \
	BIT_ULL(IRDMA_UDA_CQPSQ_MAV_WQEVALID_S)

#define IRDMA_UDA_CQPSQ_MAV_OPCODE_S 32
#define IRDMA_UDA_CQPSQ_MAV_OPCODE_M \
	((u64)0x3f << IRDMA_UDA_CQPSQ_MAV_OPCODE_S)

#define IRDMA_UDA_CQPSQ_MAV_DOLOOPBACKK_S 62
#define IRDMA_UDA_CQPSQ_MAV_DOLOOPBACKK_M \
	BIT_ULL(IRDMA_UDA_CQPSQ_MAV_DOLOOPBACKK_S)

#define IRDMA_UDA_CQPSQ_MAV_IPV4VALID_S 59
#define IRDMA_UDA_CQPSQ_MAV_IPV4VALID_M \
	BIT_ULL(IRDMA_UDA_CQPSQ_MAV_IPV4VALID_S)

#define IRDMA_UDA_CQPSQ_MAV_AVIDX_S 0
#define IRDMA_UDA_CQPSQ_MAV_AVIDX_M \
	((u64)0x1ffff << IRDMA_UDA_CQPSQ_MAV_AVIDX_S)

#define IRDMA_UDA_CQPSQ_MAV_INSERTVLANTAG_S 60
#define IRDMA_UDA_CQPSQ_MAV_INSERTVLANTAG_M BIT_ULL(IRDMA_UDA_CQPSQ_MAV_INSERTVLANTAG_S)

/* UDA multicast group */

#define IRDMA_UDA_MGCTX_VFFLAG_S 29
#define IRDMA_UDA_MGCTX_VFFLAG_M BIT_ULL(IRDMA_UDA_MGCTX_VFFLAG_S)

#define IRDMA_UDA_MGCTX_DESTPORT_S 32
#define IRDMA_UDA_MGCTX_DESTPORT_M ((u64)0xffff << IRDMA_UDA_MGCTX_DESTPORT_S)

#define IRDMA_UDA_MGCTX_VFID_S 22
#define IRDMA_UDA_MGCTX_VFID_M ((u64)0x7f << IRDMA_UDA_MGCTX_VFID_S)

#define IRDMA_UDA_MGCTX_VALIDENT_S 31
#define IRDMA_UDA_MGCTX_VALIDENT_M BIT_ULL(IRDMA_UDA_MGCTX_VALIDENT_S)

#define IRDMA_UDA_MGCTX_PFID_S 18
#define IRDMA_UDA_MGCTX_PFID_M ((u64)0xf << IRDMA_UDA_MGCTX_PFID_S)

#define IRDMA_UDA_MGCTX_FLAGIGNOREDPORT_S 30
#define IRDMA_UDA_MGCTX_FLAGIGNOREDPORT_M \
	BIT_ULL(IRDMA_UDA_MGCTX_FLAGIGNOREDPORT_S)

#define IRDMA_UDA_MGCTX_QPID_S 0
#define IRDMA_UDA_MGCTX_QPID_M ((u64)0x3ffff << IRDMA_UDA_MGCTX_QPID_S)

/* multicast group create CQP command */

#define IRDMA_UDA_CQPSQ_MG_WQEVALID_S 63
#define IRDMA_UDA_CQPSQ_MG_WQEVALID_M \
	BIT_ULL(IRDMA_UDA_CQPSQ_MG_WQEVALID_S)

#define IRDMA_UDA_CQPSQ_MG_OPCODE_S 32
#define IRDMA_UDA_CQPSQ_MG_OPCODE_M ((u64)0x3f << IRDMA_UDA_CQPSQ_MG_OPCODE_S)

#define IRDMA_UDA_CQPSQ_MG_MGIDX_S 0
#define IRDMA_UDA_CQPSQ_MG_MGIDX_M ((u64)0x1fff << IRDMA_UDA_CQPSQ_MG_MGIDX_S)

#define IRDMA_UDA_CQPSQ_MG_IPV4VALID_S 60
#define IRDMA_UDA_CQPSQ_MG_IPV4VALID_M BIT_ULL(IRDMA_UDA_CQPSQ_MG_IPV4VALID_S)

#define IRDMA_UDA_CQPSQ_MG_VLANVALID_S 59
#define IRDMA_UDA_CQPSQ_MG_VLANVALID_M BIT_ULL(IRDMA_UDA_CQPSQ_MG_VLANVALID_S)

#define IRDMA_UDA_CQPSQ_MG_HMC_FCN_ID_S 0
#define IRDMA_UDA_CQPSQ_MG_HMC_FCN_ID_M ((u64)0x3F << IRDMA_UDA_CQPSQ_MG_HMC_FCN_ID_S)

#define IRDMA_UDA_CQPSQ_MG_VLANID_S 32
#define IRDMA_UDA_CQPSQ_MG_VLANID_M ((u64)0xFFF << IRDMA_UDA_CQPSQ_MG_VLANID_S)

#define IRDMA_UDA_CQPSQ_QS_HANDLE_S 0
#define IRDMA_UDA_CQPSQ_QS_HANDLE_M ((u64)0x3FF << IRDMA_UDA_CQPSQ_QS_HANDLE_S)

/* Quad hash table */
#define IRDMA_UDA_CQPSQ_QHASH_QPN_S 32
#define IRDMA_UDA_CQPSQ_QHASH_QPN_M \
	((u64)0x3ffff << IRDMA_UDA_CQPSQ_QHASH_QPN_S)

#define IRDMA_UDA_CQPSQ_QHASH__S 0
#define IRDMA_UDA_CQPSQ_QHASH__M BIT_ULL(IRDMA_UDA_CQPSQ_QHASH__S)

#define IRDMA_UDA_CQPSQ_QHASH_SRC_PORT_S 16
#define IRDMA_UDA_CQPSQ_QHASH_SRC_PORT_M \
	((u64)0xffff << IRDMA_UDA_CQPSQ_QHASH_SRC_PORT_S)

#define IRDMA_UDA_CQPSQ_QHASH_DEST_PORT_S 0
#define IRDMA_UDA_CQPSQ_QHASH_DEST_PORT_M \
	((u64)0xffff << IRDMA_UDA_CQPSQ_QHASH_DEST_PORT_S)

#define IRDMA_UDA_CQPSQ_QHASH_ADDR0_S 32
#define IRDMA_UDA_CQPSQ_QHASH_ADDR0_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_QHASH_ADDR0_S)

#define IRDMA_UDA_CQPSQ_QHASH_ADDR1_S 0
#define IRDMA_UDA_CQPSQ_QHASH_ADDR1_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_QHASH_ADDR1_S)

#define IRDMA_UDA_CQPSQ_QHASH_ADDR2_S 32
#define IRDMA_UDA_CQPSQ_QHASH_ADDR2_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_QHASH_ADDR2_S)

#define IRDMA_UDA_CQPSQ_QHASH_ADDR3_S 0
#define IRDMA_UDA_CQPSQ_QHASH_ADDR3_M \
	((u64)0xffffffff << IRDMA_UDA_CQPSQ_QHASH_ADDR3_S)

#define IRDMA_UDA_CQPSQ_QHASH_WQEVALID_S 63
#define IRDMA_UDA_CQPSQ_QHASH_WQEVALID_M \
	BIT_ULL(IRDMA_UDA_CQPSQ_QHASH_WQEVALID_S)

#define IRDMA_UDA_CQPSQ_QHASH_OPCODE_S 32
#define IRDMA_UDA_CQPSQ_QHASH_OPCODE_M \
	((u64)0x3f << IRDMA_UDA_CQPSQ_QHASH_OPCODE_S)

#define IRDMA_UDA_CQPSQ_QHASH_MANAGE_S 61
#define IRDMA_UDA_CQPSQ_QHASH_MANAGE_M \
	((u64)0x3 << IRDMA_UDA_CQPSQ_QHASH_MANAGE_S)

#define IRDMA_UDA_CQPSQ_QHASH_IPV4VALID_S 60
#define IRDMA_UDA_CQPSQ_QHASH_IPV4VALID_M \
	((u64)0x1 << IRDMA_UDA_CQPSQ_QHASH_IPV4VALID_S)

#define IRDMA_UDA_CQPSQ_QHASH_LANFWD_S 59
#define IRDMA_UDA_CQPSQ_QHASH_LANFWD_M \
	((u64)0x1 << IRDMA_UDA_CQPSQ_QHASH_LANFWD_S)

#define IRDMA_UDA_CQPSQ_QHASH_ENTRYTYPE_S 42
#define IRDMA_UDA_CQPSQ_QHASH_ENTRYTYPE_M \
	((u64)0x7 << IRDMA_UDA_CQPSQ_QHASH_ENTRYTYPE_S)
#endif /* IRDMA_UDA_D_H */
