/******************************************************************************

  Copyright (c) 2013-2019, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

******************************************************************************/
/*$FreeBSD$*/
/**
 * @file iavf_compat_common.h
 * @brief Compatibility macros common for iflib and legacy
 *
 * Contains macro definitions for kernel compatibility that are shared between
 * the legacy and iflib driver implementations.
 */
#ifndef _IAVF_COMPAT_COMMON_H_
#define _IAVF_COMPAT_COMMON_H_

#if __FreeBSD_version >= 1200063
/* newer versions of FreeBSD use CK_STAILQ to access if_multiaddrs */
#define IF_MADDRS_HEAD		CK_STAILQ_HEAD
#define IF_MADDRS_ENTRY		CK_STAILQ_ENTRY
#define IF_MADDRS_INIT		CK_STAILQ_INIT
#define IF_MADDRS_INSERT_HEAD	CK_STAILQ_INSERT_HEAD
#define IF_MADDRS_FOREACH	CK_STAILQ_FOREACH
#else
#define IF_MADDRS_HEAD		TAILQ_HEAD
#define IF_MADDRS_ENTRY		TAILQ_ENTRY
#define IF_MADDRS_INIT		TAILQ_INIT
#define IF_MADDRS_INSERT_HEAD	TAILQ_INSERT_HEAD
#define IF_MADDRS_FOREACH	TAILQ_FOREACH
#endif

#ifndef ETHER_IS_BROADCAST
#define	ETHER_IS_BROADCAST(addr) \
	(((addr)[0] & (addr)[1] & (addr)[2] & \
	  (addr)[3] & (addr)[4] & (addr)[5]) == 0xff)
#endif

#ifndef MSEC_2_TICKS
#define MSEC_2_TICKS(m) max(1, (uint32_t)((hz == 1000) ? \
	  (m) : ((uint64_t)(m) * (uint64_t)hz)/(uint64_t)1000))
#endif

#if __FreeBSD_version <= 1100000
static __inline u_quad_t uqmax(u_quad_t a, u_quad_t b)
{
	return (a > b ? a : b);
}
#endif

/* Older versions of FreeBSD do not have all the if_media type macros, so
 * we'll treat them as IFM_UNKNOWN.
 */
#ifndef IFM_10G_AOC
#define IFM_10G_AOC IFM_UNKNOWN
#endif

#ifndef IFM_25G_LR
#define IFM_25G_LR IFM_UNKNOWN
#endif

#ifndef IFM_25G_AOC
#define IFM_25G_AOC IFM_UNKNOWN
#endif

/*
 * We can check for just IFM_100_SGMII since the following media types
 * were all added at the same time.
 */
#ifndef IFM_100_SGMII
#define	IFM_100_SGMII	IFM_UNKNOWN
#define	IFM_2500_X	IFM_UNKNOWN
#define	IFM_5000_KR	IFM_UNKNOWN
#define	IFM_25G_T	IFM_UNKNOWN
#define	IFM_25G_CR_S	IFM_UNKNOWN
#define	IFM_25G_CR1	IFM_UNKNOWN
#define	IFM_25G_KR_S	IFM_UNKNOWN
#define	IFM_5000_KR_S	IFM_UNKNOWN
#define	IFM_5000_KR1	IFM_UNKNOWN
#define	IFM_25G_AUI	IFM_UNKNOWN
#define	IFM_40G_XLAUI	IFM_UNKNOWN
#define	IFM_40G_XLAUI_AC IFM_UNKNOWN
#define	IFM_50G_SR2	IFM_UNKNOWN
#define	IFM_50G_LR2	IFM_UNKNOWN
#define	IFM_50G_LAUI2_AC IFM_UNKNOWN
#define	IFM_50G_LAUI2	IFM_UNKNOWN
#define	IFM_50G_AUI2_AC	IFM_UNKNOWN
#define	IFM_50G_AUI2	IFM_UNKNOWN
#define	IFM_50G_CP	IFM_UNKNOWN
#define	IFM_50G_SR	IFM_UNKNOWN
#define	IFM_50G_LR	IFM_UNKNOWN
#define	IFM_50G_FR	IFM_UNKNOWN
#define	IFM_50G_KR_PAM4	IFM_UNKNOWN
#define	IFM_25G_KR1	IFM_UNKNOWN
#define	IFM_50G_AUI1_AC	IFM_UNKNOWN
#define	IFM_50G_AUI1	IFM_UNKNOWN
#define	IFM_100G_CAUI4_AC IFM_UNKNOWN
#define	IFM_100G_CAUI4 IFM_UNKNOWN
#define	IFM_100G_AUI4_AC IFM_UNKNOWN
#define	IFM_100G_AUI4 IFM_UNKNOWN
#define	IFM_100G_CR_PAM4 IFM_UNKNOWN
#define	IFM_100G_KR_PAM4 IFM_UNKNOWN
#define	IFM_100G_CP2	IFM_UNKNOWN
#define	IFM_100G_SR2	IFM_UNKNOWN
#define	IFM_100G_DR	IFM_UNKNOWN
#define	IFM_100G_KR2_PAM4 IFM_UNKNOWN
#define	IFM_100G_CAUI2_AC IFM_UNKNOWN
#define	IFM_100G_CAUI2	IFM_UNKNOWN
#define	IFM_100G_AUI2_AC IFM_UNKNOWN
#define	IFM_100G_AUI2	IFM_UNKNOWN
#endif

#endif /* _IAVF_COMPAT_COMMON_H_ */
