/*******************************************************************************
*
* Copyright (c) 2015-2019 Intel Corporation.  All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses.  You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* COPYING in the main directory of this source tree, or the
* OpenFabrics.org BSD license below:
*
*   Redistribution and use in source and binary forms, with or
*   without modification, are permitted provided that the following
*   conditions are met:
*
*    - Redistributions of source code must retain the above
*	copyright notice, this list of conditions and the following
*	disclaimer.
*
*    - Redistributions in binary form must reproduce the above
*	copyright notice, this list of conditions and the following
*	disclaimer in the documentation and/or other materials
*	provided with the distribution.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
* BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
* ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
*******************************************************************************/

#ifndef KCOMPAT_H
#define KCOMPAT_H
#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#else
#define KERNEL_VERSION(a, b, c) (((a) << 16) + ((b) << 8) + (c))
#endif /* LINUX_VERSION_CODE */
#include <linux/init.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/module.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/list.h>
#include <linux/delay.h>
#include <linux/sched.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/mii.h>
#include <linux/vmalloc.h>
#include <asm/io.h>
#include <linux/ethtool.h>
#include <linux/if_vlan.h>
#include <net/ipv6.h>
#include <net/ip6_route.h>
#include <net/route.h>
#ifndef RHEL_RELEASE_VERSION
#define RHEL_RELEASE_VERSION(a,b) (((a) << 8) + (b))
#endif
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3, 4, 0)
#include <linux/kconfig.h>
#endif
#ifndef SLE_VERSION
#define SLE_VERSION(a,b,c)      KERNEL_VERSION(a,b,c)
#endif
#define SLE_LOCALVERSION(a,b,c) KERNEL_VERSION(a,b,c)

#ifndef SLE_VERSION_CODE
#define SLE_VERSION_CODE 0
#endif /* SLE_VERSION_CODE */
#ifndef SLE_LOCALVERSION_CODE
#define SLE_LOCALVERSION_CODE 0
#endif /* SLE_LOCALVERSION_CODE */

#ifdef CONFIG_SUSE_KERNEL
#if ((LINUX_VERSION_CODE == KERNEL_VERSION(4,4,73) || \
        LINUX_VERSION_CODE == KERNEL_VERSION(4,4,82) || \
        LINUX_VERSION_CODE == KERNEL_VERSION(4,4,92)) || \
       (LINUX_VERSION_CODE == KERNEL_VERSION(4,4,103) && \
       (SLE_LOCALVERSION_CODE == KERNEL_VERSION(6,33,0) || \
        SLE_LOCALVERSION_CODE == KERNEL_VERSION(6,38,0))) || \
       (LINUX_VERSION_CODE >= KERNEL_VERSION(4,4,114) && \
        LINUX_VERSION_CODE < KERNEL_VERSION(4,5,0) && \
        SLE_LOCALVERSION_CODE >= KERNEL_VERSION(94,0,0) && \
        SLE_LOCALVERSION_CODE <  KERNEL_VERSION(95,0,0)) )
#define SLE_VERSION_CODE SLE_VERSION(12,3,0)
#elif (LINUX_VERSION_CODE == KERNEL_VERSION(4,12,14) && \
       (SLE_LOCALVERSION_CODE == KERNEL_VERSION(94,41,0) || \
       (SLE_LOCALVERSION_CODE >= KERNEL_VERSION(95,0,0) && \
        SLE_LOCALVERSION_CODE < KERNEL_VERSION(96,0,0))))
#define SLE_VERSION_CODE SLE_VERSION(12,4,0)
#elif (LINUX_VERSION_CODE == KERNEL_VERSION(4,12,14) && \
       (SLE_LOCALVERSION_CODE == KERNEL_VERSION(23,0,0) || \
        SLE_LOCALVERSION_CODE == KERNEL_VERSION(2,0,0) || \
        SLE_LOCALVERSION_CODE == KERNEL_VERSION(136,0,0) || \
        (SLE_LOCALVERSION_CODE >= KERNEL_VERSION(25,0,0) && \
         SLE_LOCALVERSION_CODE < KERNEL_VERSION(26,0,0))))
#define SLE_VERSION_CODE SLE_VERSION(15,0,0)
#endif /* LINUX_VERSION_CODE */ 
#endif /* CONFIG_SUSE_KERNEL */

struct dst_entry *i40iw_get_fl6_dst(struct sockaddr_in6 *, struct sockaddr_in6 *);
struct neighbour *i40iw_get_neigh_ipv6(struct dst_entry *, struct sockaddr_in6 *);
struct neighbour *i40iw_get_neigh_ipv4(struct rtable *, __be32 *);

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 14, 0)
#define ether_addr_copy(mac_addr, new_mac_addr) memcpy(mac_addr, new_mac_addr, ETH_ALEN)
#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 7, 0)
#define eth_zero_addr(mac_addr) memset(mac_addr, 0x00, ETH_ALEN)
#endif /* < 3.7.0 */
#endif /* < 3.14.0 */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 35)
#define i40iw_for_each_ipv6_addr(ifp, tmp, idev) list_for_each_entry_safe(ifp, tmp, &idev->addr_list, if_list)
#else
#define i40iw_for_each_ipv6_addr(ifp, tmp, idev) for (ifp = idev->addr_list; ifp; ifp = ifp->if_next)
#endif /* >= 2.6.35 */

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 9, 0)
#define netdev_master_upper_dev_get i40iw_netdev_master_upper_dev_get
struct net_device *i40iw_netdev_master_upper_dev_get(struct net_device *);
#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 1, 0)
#define neigh_release(neigh)
#endif /* < 3.1.0 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 39)
#define ip_route_output i40iw_ip_route_output
struct rtable *i40iw_ip_route_output(struct net *, __be32, __be32, u8, int);
#endif /* < 2.6.39 */
#endif /* < 3.9.0 */

#if defined(RHEL_RELEASE_CODE) && RHEL_RELEASE_CODE < RHEL_RELEASE_VERSION(7, 7)
#define kc_set_device_id(X)
#else
#ifdef CONFIG_SUSE_KERNEL
#if SLE_VERSION_CODE <= SLE_VERSION(15,0,0)
#define kc_set_device_id(X)
#endif
#else
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 17, 0)
#define kc_set_device_id(ibdev) ibdev.driver_id = RDMA_DRIVER_I40IW
#else
#define kc_set_device_id(X)
#endif /* 4.17.0 */
#endif /* CONFIG_SUSE_KERNEL */
#endif /* * RHEL 7.7 */

#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 19, 0)
#define kc_type_ib_wr
#else
#define kc_type_ib_wr const
#endif /* * 4.19.0 */
 
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 20, 0)
#define kc_ib_register_device(device, name, port_callback) \
	ib_register_device(device, port_callback)
#else
#define kc_ib_register_device(device, name, port_callback) \
	ib_register_device(device, name, port_callback)
#endif /* < 4.20.0 */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 0, 0)
#define kc_dereg_mr(iwibdev, iwqp) \
	iwibdev->ibdev.ops.dereg_mr(iwqp->lsmm_mr)	
#else
#define kc_dereg_mr(iwibdev, iwqp) \
	iwibdev->ibdev.dereg_mr(iwqp->lsmm_mr)
#endif /* * 5.0.0 */


#endif /* _KCOMPAT_H_ */
