/**************************************************************************

Copyright (c) 2016, Intel Corporation

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/


#include <wol.h>

_WOL_DEVICE_INFO_t const WOL_DEVICE_INFO_TABLE[] = {
/* Vendor   DeviceID SubVendor SubSystem  WoL*/



#if defined(WOL_40G)
 { 0x8086, 0x104E, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10 Gigabit SFP+ */
 { 0x8086, 0x104F, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10 Gigabit backplane */
 { 0x8086, 0x10A6, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) X710 Multi-Function Network Device */
 { 0x8086, 0x1572, 0x1028, 0x0000, 0xF }, /* Intel(R) Ethernet 10G X710 rNDC */
 { 0x8086, 0x1572, 0x1028, 0x1F99, 0xF }, /* Intel(R) Ethernet 10G 4P X710/I350 rNDC */
 { 0x8086, 0x1572, 0x1028, 0x1F9C, 0xF }, /* Intel(R) Ethernet 10G 4P X710 SFP+ rNDC */
 { 0x8086, 0x1572, 0x103C, 0x0000, 0xF }, /* HPE Ethernet 10Gb 562SFP+ Adapter */
 { 0x8086, 0x1572, 0x103C, 0x22FC, 0xF }, /* HPE Ethernet 10Gb 2-port 562FLR-SFP+ Adapter */
 { 0x8086, 0x1572, 0x103C, 0x22FD, 0xF }, /* HPE Ethernet 10Gb 2-port 562SFP+ Adapter */
 { 0x8086, 0x1572, 0x1137, 0x0000, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-DA */
 { 0x8086, 0x1572, 0x1137, 0x013B, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-DA4 */
 { 0x8086, 0x1572, 0x1137, 0x020A, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-DA2 */
 { 0x8086, 0x1572, 0x17AA, 0x0000, 0xF }, /* Lenovo ThinkServer X710 AnyFabric for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x17AA, 0x4001, 0xF }, /* Lenovo ThinkServer X710-4 AnyFabric for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x17AA, 0x4002, 0xF }, /* Lenovo ThinkServer X710-2 AnyFabric for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710 */
 { 0x8086, 0x1572, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-4 */
 { 0x8086, 0x1572, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-4 */
 { 0x8086, 0x1572, 0x8086, 0x0004, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-4 */
 { 0x8086, 0x1572, 0x8086, 0x0005, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710 */
 { 0x8086, 0x1572, 0x8086, 0x0006, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710 */
 { 0x8086, 0x1572, 0x8086, 0x0007, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-2 */
 { 0x8086, 0x1572, 0x8086, 0x0008, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-2 */
 { 0x8086, 0x1572, 0x8086, 0x0009, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x000A, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x000B, 0xF }, /* Intel(R) Ethernet Server Adapter X710-DA2 for OCP */
 { 0x8086, 0x1572, 0x8086, 0x000D, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x000E, 0xF }, /* Intel(R) Ethernet Server Adapter OCP X710-2 */
 { 0x8086, 0x1572, 0x8086, 0x0013, 0xF }, /* Intel(R) Ethernet 10G 2P X710 OCP */
 { 0x8086, 0x1572, 0x8086, 0x0014, 0xF }, /* Intel(R) Ethernet 10G 4P X710 OCP */
 { 0x8086, 0x1572, 0x8086, 0x4005, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x4006, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0x8086, 0x4007, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1572, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE SFP+ */
 { 0x8086, 0x1580, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 40GbE backplane */
 { 0x8086, 0x1581, 0x1028, 0x0000, 0xF }, /* Intel(R) Ethernet 10G X710-k bNDC */
 { 0x8086, 0x1581, 0x1028, 0x1F98, 0xF }, /* Intel(R) Ethernet 10G 4P X710-k bNDC */
 { 0x8086, 0x1581, 0x1028, 0x1F9E, 0xF }, /* Intel(R) Ethernet 10G 2P X710-k bNDC */
 { 0x8086, 0x1581, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GbE backplane */
 { 0x8086, 0x1583, 0x1028, 0x0000, 0xF }, /* Intel(R) Ethernet 40G 2P XL710 QSFP+ rNDC */
 { 0x8086, 0x1583, 0x1028, 0x1F9F, 0xF }, /* Intel(R) Ethernet 40G 2P XL710 QSFP+ rNDC */
 { 0x8086, 0x1583, 0x108E, 0x0000, 0xF }, /* Oracle 10 Gb/40 Gb Ethernet Adapter */
 { 0x8086, 0x1583, 0x108E, 0x7B1B, 0xF }, /* Oracle Quad 10Gb Ethernet Adapter */
 { 0x8086, 0x1583, 0x108E, 0x7B1D, 0xF }, /* Oracle 10 Gb/40 Gb Ethernet Adapter */
 { 0x8086, 0x1583, 0x1137, 0x0000, 0xF }, /* Cisco(R) Ethernet Converged NIC XL710-QDA2 */
 { 0x8086, 0x1583, 0x1137, 0x013C, 0xF }, /* Cisco(R) Ethernet Converged NIC XL710-QDA2 */
 { 0x8086, 0x1583, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet I/O Module XL710-Q2 */
 { 0x8086, 0x1583, 0x8086, 0x0006, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q2 */
 { 0x8086, 0x1583, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 40GbE QSFP+ */
 { 0x8086, 0x1584, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q1 */
 { 0x8086, 0x1584, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q1 */
 { 0x8086, 0x1584, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter XL710-Q1 */
 { 0x8086, 0x1584, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet I/O Module XL710-Q1 */
 { 0x8086, 0x1584, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 40GbE QSFP+ */
 { 0x8086, 0x1585, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XL710 for 10GbE QSFP+ */
 { 0x8086, 0x1586, 0x108E, 0x0000, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x1586, 0x108E, 0x4857, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x1586, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x1589, 0x108E, 0x0000, 0xF }, /* Oracle Quad Port 10GBase-T Adapter */
 { 0x8086, 0x1589, 0x108E, 0x7B1C, 0xF }, /* Oracle Quad Port 10GBase-T Adapter */
 { 0x8086, 0x1589, 0x1137, 0x0000, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-T4 */
 { 0x8086, 0x1589, 0x1137, 0x020B, 0xF }, /* Cisco(R) Ethernet Converged NIC X710-T4 */
 { 0x8086, 0x1589, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T */
 { 0x8086, 0x1589, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T4 */
 { 0x8086, 0x1589, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T4 */
 { 0x8086, 0x1589, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T */
 { 0x8086, 0x1589, 0x8086, 0x00A0, 0xF }, /* Intel(R) Ethernet Converged Network Adapter X710-T4 */
 { 0x8086, 0x1589, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710/X557-AT 10GBASE-T */
 { 0x8086, 0x158A, 0x1590, 0x0000, 0xF }, /* HPE 10/25Gb Ethernet Adapter */
 { 0x8086, 0x158A, 0x1590, 0x0286, 0xF }, /* HPE Synergy 4610C 10/25Gb Ethernet Adapter */
 { 0x8086, 0x158A, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Controller XXV710 for 25GbE backplane */
 { 0x8086, 0x158A, 0x8086, 0x000A, 0xF }, /* Intel(R) Ethernet 25G 2P XXV710 Mezz */
 { 0x8086, 0x158A, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XXV710 for 25GbE backplane */
 { 0x8086, 0x158B, 0x1137, 0x0000, 0xF }, /* Cisco(R) Ethernet Network Adapter XXV710 */
 { 0x8086, 0x158B, 0x1137, 0x0225, 0xF }, /* Cisco(R) Ethernet Network Adapter XXV710 */
 { 0x8086, 0x158B, 0x8086, 0x0000, 0xF }, /* Intel(R) Ethernet Network Adapter XXV710 */
 { 0x8086, 0x158B, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Network Adapter XXV710-2 */
 { 0x8086, 0x158B, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Network Adapter XXV710-2 */
 { 0x8086, 0x158B, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet Network Adapter XXV710-1 */
 { 0x8086, 0x158B, 0x8086, 0x0004, 0xF }, /* Intel(R) Ethernet Network Adapter XXV710-1 */
 { 0x8086, 0x158B, 0x8086, 0x0005, 0xF }, /* Intel(R) Ethernet Network Adapter OCP XXV710-2 */
 { 0x8086, 0x158B, 0x8086, 0x0006, 0xF }, /* Intel(R) Ethernet Network Adapter OCP XXV710-2 */
 { 0x8086, 0x158B, 0x8086, 0x0007, 0xF }, /* Intel(R) Ethernet Network Adapter OCP XXV710-1 */
 { 0x8086, 0x158B, 0x8086, 0x0008, 0xF }, /* Intel(R) Ethernet Network Adapter OCP XXV710-1 */
 { 0x8086, 0x158B, 0x8086, 0x0009, 0xF }, /* Intel(R) Ethernet 25G 2P XXV710 Adapter */
 { 0x8086, 0x158B, 0x8086, 0x4001, 0xF }, /* Intel(R) Ethernet Network Adapter XXV710-2 */
 { 0x8086, 0x158B, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller XXV710 for 25GbE SFP28 */
 { 0x8086, 0x15FF, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Controller X710 for 10GBASE-T */
 { 0x8086, 0x37CC, 0xFFFF, 0xFFFF, 0x0 }, /* Intel(R) Ethernet Connection X722 */
 { 0x8086, 0x37CE, 0x1590, 0x0215, 0xF }, /* HPE Ethernet 10Gb 2-port 568i Adapter */
 { 0x8086, 0x37CE, 0x17AA, 0x4023, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE backplane */
 { 0x8086, 0x37CE, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE backplane */
 { 0x8086, 0x37CF, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE QSFP+ */
 { 0x8086, 0x37D0, 0x8086, 0x0001, 0xF }, /* Intel(R) Ethernet Network Adapter X722-2 */
 { 0x8086, 0x37D0, 0x8086, 0x0002, 0xF }, /* Intel(R) Ethernet Network Adapter X722-2 */
 { 0x8086, 0x37D0, 0x8086, 0x0003, 0xF }, /* Intel(R) Ethernet Network Adapter X722-4 */
 { 0x8086, 0x37D0, 0x8086, 0x0004, 0xF }, /* Intel(R) Ethernet Network Adapter X722-4 */
 { 0x8086, 0x37D0, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE SFP+ */
 { 0x8086, 0x37D1, 0x1590, 0x0216, 0xF }, /* HPE Ethernet 1Gb 2-port 368i Adapter */
 { 0x8086, 0x37D1, 0x1590, 0x0217, 0xF }, /* HPE Ethernet 1Gb 2-port 368FLR-MMT Adapter */
 { 0x8086, 0x37D1, 0x1590, 0x0247, 0xF }, /* HPE Ethernet 1Gb 4-port 369i Adapter */
 { 0x8086, 0x37D1, 0x17AA, 0x4020, 0xF }, /* Intel(R) Ethernet Connection X722 for 1GbE */
 { 0x8086, 0x37D1, 0x17AA, 0x4021, 0xF }, /* Intel(R) Ethernet Connection X722 for 1GbE */
 { 0x8086, 0x37D1, 0x17AA, 0x4022, 0xF }, /* Intel(R) Ethernet Connection X722 for 1GbE */
 { 0x8086, 0x37D1, 0x17AA, 0x4024, 0xF }, /* Intel(R) Ethernet Connection X722 for 1GbE */
 { 0x8086, 0x37D1, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X722 for 1GbE */
 { 0x8086, 0x37D2, 0x1590, 0x0218, 0xF }, /* HPE Ethernet 10Gb 2-port 568FLR-MMT Adapter */
 { 0x8086, 0x37D2, 0x17AA, 0x4020, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GBASE-T */
 { 0x8086, 0x37D2, 0x17AA, 0x4021, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GBASE-T */
 { 0x8086, 0x37D2, 0x17AA, 0x4024, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GBASE-T */
 { 0x8086, 0x37D2, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GBASE-T */
 { 0x8086, 0x37D3, 0x1590, 0x0219, 0xF }, /* HPE Ethernet 10Gb 2-port 568FLR-MMSFP+ Adapter */
 { 0x8086, 0x37D3, 0x17AA, 0x4020, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE SFP+ */
 { 0x8086, 0x37D3, 0x17AA, 0x4021, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE SFP+ */
 { 0x8086, 0x37D3, 0xFFFF, 0xFFFF, 0xF }, /* Intel(R) Ethernet Connection X722 for 10GbE SFP+ */
#endif /* WOL_40G */

 {      0,      0,      0,      0,   0 }  /* Last entry */
};

