#!/bin/sh

# script for building the rdma driver icrdma.
# A path to ice driver sources should be provided
# as an argument of this script to ensure the driver
# builds correctly.
# if second argument is equal to 'true' the libirdma
# is also updated during building process.

DIR_ICE=$1
update_lib=$2

cd src/
make clean
make ICE_DIR=$DIR_ICE COPTS=-g
if [ "$?" -ne "0" ]
then
	exit 1
fi
make install

if [ "$update_lib" == "true" ]
then
        cd ..
        mkdir -p /usr/src/lib/ofed/libirdma
        cp lib_Makefile /usr/src/lib/ofed/libirdma/Makefile
        if [ -e /usr/src/contrib/ofed/libirdma ]
        then
                mv /usr/src/contrib/ofed/libirdma /usr/src/contrib/ofed/bkp_libirdma
                cp -r libirdma /usr/src/contrib/ofed/
        else
                cp -r libirdma /usr/src/contrib/ofed/
        fi
        cd /usr/src/lib/ofed/libirdma
        make clean ; make -j4 ; make install
fi

