﻿<# 
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Name : AscendingSortNetworkAdapterByMac.ps1
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Purpose : Sort Windows Network Adapter by MAC Address via PowerShell Script - Ascending
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Dependent Table
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Known Issues
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Methodology
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	References
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	MSDN documents
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Internal documents
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Internet documents
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Create Date : 2019-05-23										Create User : Alex
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Update Date : 2019-08-19										Update User : Alex
 *-------------------------------------------------------------------------------------------------------------------------------------->
#>

param
(
	[string]$DeviceName = "Intel(R) I210 Gigabit Network Connection",
	[string]$PrefixName = "Ethernet",
	[int]$StartingNumber = 1
)

# Get Network Adapter MAC Address
Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Rename Network Adapters - Temporary (Network Adapters - Alias Name)"
$intIndex = $StartingNumber
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strNetNameOld = $LoopNetAdapter.Name
    $strNteNameTmp = Get-Date -Format HHmmssfff
    $strNetNameNew = $strNteNameTmp + $intIndex
    $LoopNetAdapter | Rename-NetAdapter -NewName $strNetNameNew 
    $intIndex++
    Write-Host "Rename: " $strNetNameOld " to:" $strNetNameNew
}

# Get Network Adapter MAC Address
Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Rename Network Adapters - Final (Network Adapters - Alias Name)"
$intIndex = $StartingNumber
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strNetNameOld = $LoopNetAdapter.Name
    $strNetNameNew = $PrefixName + $intIndex
    $LoopNetAdapter | Rename-NetAdapter -NewName $strNetNameNew     
    $intIndex++
    Write-Host "Rename: " $strNetNameOld " to:" $strNetNameNew
}

