﻿<# 
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Name : AscendingSortNetworkAdapterByMac.ps1
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Purpose : Sort Windows Network Adapter by MAC Address via PowerShell Script - Ascending
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Dependent Table
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Known Issues
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Methodology
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	References
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	MSDN documents
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Internal documents
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Internet documents
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Create Date : 2021-07-20										Create User : Alex
 *-------------------------------------------------------------------------------------------------------------------------------------->
 *	Update Date : 2021-07-27										Update User : Alex
 *-------------------------------------------------------------------------------------------------------------------------------------->
#>

param
(
	[string]$PrefixName = "Ethernet",
	[int]$StartingNumber = 1
)

Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Keep Network Adapters - (Network Adapters - Device Manager Name)"
$objNetAdaptersDictionary = @{}
$strRegKeyRoot = "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\"
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strFilterArgument = "GUID='" + $LoopNetAdapter.DeviceID + "'"
	$objPNPDeviceID = Get-WmiObject Win32_NetworkAdapter -Filter $strFilterArgument -Property PNPDeviceID
	$strRegKeyChild = $strRegKeyRoot + $objPNPDeviceID.PNPDeviceID
	$strFriendlyName = (Get-ItemProperty Registry::$strRegKeyChild).FriendlyName
	if ($strFriendlyName.IndexOf("#") -ge 0)
	{
		$strFriendlyName = $strFriendlyName.SubString(0, $strFriendlyName.IndexOf("#"))
	}	
	$objNetAdaptersDictionary.add($LoopNetAdapter.DeviceID, $strFriendlyName)
}

Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Rename Network Adapters - Temporary (Network Adapters - Alias Name)"
$intIndex = $StartingNumber
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strNetNameOld = $LoopNetAdapter.Name
    $strNteNameTmp = Get-Date -Format HHmmssfff
    $strNetNameNew = $strNteNameTmp + $intIndex
    $LoopNetAdapter | Rename-NetAdapter -NewName $strNetNameNew 
    $intIndex++
    Write-Host "Rename: " $strNetNameOld " to:" $strNetNameNew
}

Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Rename Network Adapters - Final (Network Adapters - Alias Name)"
$intIndex = $StartingNumber
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strNetNameOld = $LoopNetAdapter.Name	
	$strNetNameNew = $PrefixName + $intIndex
    $LoopNetAdapter | Rename-NetAdapter -NewName $strNetNameNew     
    $intIndex++
    Write-Host "Rename: " $strNetNameOld " to:" $strNetNameNew
}

Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Rename Network Adapters - Temporary (Network Adapters - Device Manager Name)"
$intIndex = $StartingNumber
$strRegKeyRoot = "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\"
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strFilterArgument = "GUID='" + $LoopNetAdapter.DeviceID + "'"
	$objPNPDeviceID = Get-WmiObject Win32_NetworkAdapter -Filter $strFilterArgument -Property PNPDeviceID
	$strRegKeyChild = $strRegKeyRoot + $objPNPDeviceID.PNPDeviceID
	$strNetNameOld = (Get-ItemProperty Registry::$strRegKeyChild).FriendlyName
	$strNteNameTmp = Get-Date -Format HHmmssfff    
	$strNetNameNew = $strNteNameTmp + "# " + $intIndex
	Set-ItemProperty Registry::$strRegKeyChild -Name "FriendlyName" -Value $strNetNameNew
    $intIndex++
    Write-Host "Rename: " $strNetNameOld " to:" $strNetNameNew    
}

Write-Host "Get Network Adapters MAC Address"
$objNetAdapters = Get-NetAdapter | Sort-Object MacAddress

Write-Host "Rename Network Adapters - Final (Network Adapters - Device Manager Name)"
$intIndex = $StartingNumber
$strRegKeyRoot = "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\"
$strNteNameTmp = ""
foreach ($LoopNetAdapter in $objNetAdapters)
{
	$strFilterArgument = "GUID='" + $LoopNetAdapter.DeviceID + "'"
	$objPNPDeviceID = Get-WmiObject Win32_NetworkAdapter -Filter $strFilterArgument -Property PNPDeviceID
	$strRegKeyChild = $strRegKeyRoot + $objPNPDeviceID.PNPDeviceID
	$strNetNameOld = (Get-ItemProperty Registry::$strRegKeyChild).FriendlyName
	if ($strNteNameTmp -eq $objNetAdaptersDictionary[$LoopNetAdapter.DeviceID])
	{
		$strNteNameTmp = $objNetAdaptersDictionary[$LoopNetAdapter.DeviceID] + "# " + $intIndex
	}
	else
	{
		$strNteNameTmp = $objNetAdaptersDictionary[$LoopNetAdapter.DeviceID]
	}	
	$strNetNameNew = $strNteNameTmp
	Set-ItemProperty Registry::$strRegKeyChild -Name "FriendlyName" -Value $strNetNameNew
    $intIndex++
    Write-Host "Rename: " $strNetNameOld " to:" $strNetNameNew    
}

Restart-Computer
